/*
 * Decompiled with CFR 0.152.
 */
package Microsoft.Telemetry;

import Microsoft.Telemetry.Base;
import Microsoft.Telemetry.Extension;
import com.microsoft.bond.BondDataType;
import com.microsoft.bond.BondMirror;
import com.microsoft.bond.BondSerializable;
import com.microsoft.bond.Bonded;
import com.microsoft.bond.FieldDef;
import com.microsoft.bond.Metadata;
import com.microsoft.bond.Modifier;
import com.microsoft.bond.ProtocolCapability;
import com.microsoft.bond.ProtocolReader;
import com.microsoft.bond.ProtocolWriter;
import com.microsoft.bond.SchemaDef;
import com.microsoft.bond.StructDef;
import com.microsoft.bond.TypeDef;
import com.microsoft.bond.internal.Marshaler;
import com.microsoft.bond.internal.ReadHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Envelope
implements BondSerializable,
BondMirror {
    private String ver;
    private String name;
    private String time;
    private double popSample;
    private String epoch;
    private long seqNum;
    private String iKey;
    private long flags;
    private String os;
    private String osVer;
    private String appId;
    private String appVer;
    private String cV;
    private HashMap<String, String> tags;
    private HashMap<String, Bonded<Extension>> ext;
    private Bonded<Base> data;

    public BondSerializable clone() {
        return null;
    }

    public final String getVer() {
        return this.ver;
    }

    public final void setVer(String value) {
        this.ver = value;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    public final String getTime() {
        return this.time;
    }

    public final void setTime(String value) {
        this.time = value;
    }

    public final double getPopSample() {
        return this.popSample;
    }

    public final void setPopSample(double value) {
        this.popSample = value;
    }

    public final String getEpoch() {
        return this.epoch;
    }

    public final void setEpoch(String value) {
        this.epoch = value;
    }

    public final long getSeqNum() {
        return this.seqNum;
    }

    public final void setSeqNum(long value) {
        this.seqNum = value;
    }

    public final String getIKey() {
        return this.iKey;
    }

    public final void setIKey(String value) {
        this.iKey = value;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final void setFlags(long value) {
        this.flags = value;
    }

    public final String getOs() {
        return this.os;
    }

    public final void setOs(String value) {
        this.os = value;
    }

    public final String getOsVer() {
        return this.osVer;
    }

    public final void setOsVer(String value) {
        this.osVer = value;
    }

    public final String getAppId() {
        return this.appId;
    }

    public final void setAppId(String value) {
        this.appId = value;
    }

    public final String getAppVer() {
        return this.appVer;
    }

    public final void setAppVer(String value) {
        this.appVer = value;
    }

    public final String getCV() {
        return this.cV;
    }

    public final void setCV(String value) {
        this.cV = value;
    }

    public final HashMap<String, String> getTags() {
        return this.tags;
    }

    public final void setTags(HashMap<String, String> value) {
        this.tags = value;
    }

    public final HashMap<String, Bonded<Extension>> getExt() {
        return this.ext;
    }

    public final void setExt(HashMap<String, Bonded<Extension>> value) {
        this.ext = value;
    }

    public final Bonded<Base> getData() {
        return this.data;
    }

    public final void setData(Bonded<Base> value) {
        this.data = value;
    }

    public Object getField(FieldDef fieldDef) {
        switch (fieldDef.getId()) {
            case 10: {
                return this.ver;
            }
            case 20: {
                return this.name;
            }
            case 30: {
                return this.time;
            }
            case 40: {
                return this.popSample;
            }
            case 50: {
                return this.epoch;
            }
            case 60: {
                return this.seqNum;
            }
            case 70: {
                return this.iKey;
            }
            case 80: {
                return this.flags;
            }
            case 90: {
                return this.os;
            }
            case 100: {
                return this.osVer;
            }
            case 110: {
                return this.appId;
            }
            case 120: {
                return this.appVer;
            }
            case 130: {
                return this.cV;
            }
            case 500: {
                return this.tags;
            }
            case 510: {
                return this.ext;
            }
            case 999: {
                return this.data;
            }
        }
        return null;
    }

    public void setField(FieldDef fieldDef, Object value) {
        switch (fieldDef.getId()) {
            case 10: {
                this.ver = (String)value;
                break;
            }
            case 20: {
                this.name = (String)value;
                break;
            }
            case 30: {
                this.time = (String)value;
                break;
            }
            case 40: {
                this.popSample = (Double)value;
                break;
            }
            case 50: {
                this.epoch = (String)value;
                break;
            }
            case 60: {
                this.seqNum = (Long)value;
                break;
            }
            case 70: {
                this.iKey = (String)value;
                break;
            }
            case 80: {
                this.flags = (Long)value;
                break;
            }
            case 90: {
                this.os = (String)value;
                break;
            }
            case 100: {
                this.osVer = (String)value;
                break;
            }
            case 110: {
                this.appId = (String)value;
                break;
            }
            case 120: {
                this.appVer = (String)value;
                break;
            }
            case 130: {
                this.cV = (String)value;
                break;
            }
            case 500: {
                this.tags = (HashMap)value;
                break;
            }
            case 510: {
                this.ext = (HashMap)value;
                break;
            }
            case 999: {
                this.data = (Bonded)value;
            }
        }
    }

    public BondMirror createInstance(StructDef structDef) {
        if (Extension.Schema.metadata == structDef.getMetadata()) {
            return new Extension();
        }
        if (Base.Schema.metadata == structDef.getMetadata()) {
            return new Base();
        }
        return null;
    }

    public SchemaDef getSchema() {
        return Envelope.getRuntimeSchema();
    }

    public static SchemaDef getRuntimeSchema() {
        return Schema.schemaDef;
    }

    public Envelope() {
        this.reset();
    }

    public void reset() {
        this.reset("Envelope", "Microsoft.Telemetry.Envelope");
    }

    protected void reset(String name, String qualifiedName) {
        this.ver = "";
        this.name = "";
        this.time = "";
        this.popSample = 100.0;
        this.epoch = "";
        this.seqNum = 0L;
        this.iKey = "";
        this.flags = 0L;
        this.os = "";
        this.osVer = "";
        this.appId = "";
        this.appVer = "";
        this.cV = "";
        if (this.tags == null) {
            this.tags = new HashMap();
        } else {
            this.tags.clear();
        }
        if (this.ext == null) {
            this.ext = new HashMap();
        } else {
            this.ext.clear();
        }
        this.data = new Bonded();
    }

    public void unmarshal(InputStream input) throws IOException {
        Marshaler.unmarshal((InputStream)input, (BondSerializable)this);
    }

    public void unmarshal(InputStream input, BondSerializable schema) throws IOException {
        Marshaler.unmarshal((InputStream)input, (BondSerializable)((SchemaDef)schema), (BondSerializable)this);
    }

    public void read(ProtocolReader reader) throws IOException {
        reader.readBegin();
        this.readNested(reader);
        reader.readEnd();
    }

    public void readNested(ProtocolReader reader) throws IOException {
        if (!reader.hasCapability(ProtocolCapability.TAGGED)) {
            this.readUntagged(reader, false);
        } else if (this.readTagged(reader, false)) {
            ReadHelper.skipPartialStruct((ProtocolReader)reader);
        }
    }

    public void read(ProtocolReader reader, BondSerializable schema) throws IOException {
    }

    protected void readUntagged(ProtocolReader reader, boolean isBase) throws IOException {
        boolean canOmitFields = reader.hasCapability(ProtocolCapability.CAN_OMIT_FIELDS);
        reader.readStructBegin(isBase);
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.ver = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.name = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.time = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.popSample = reader.readDouble();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.epoch = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.seqNum = reader.readInt64();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.iKey = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.flags = reader.readInt64();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.os = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.osVer = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.appId = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.appVer = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.cV = reader.readString();
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.readFieldImpl_tags(reader, BondDataType.BT_MAP);
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.readFieldImpl_ext(reader, BondDataType.BT_MAP);
        }
        if (!canOmitFields || !reader.readFieldOmitted()) {
            this.data.read(reader);
        }
        reader.readStructEnd();
    }

    protected boolean readTagged(ProtocolReader reader, boolean isBase) throws IOException {
        ProtocolReader.FieldTag fieldTag;
        reader.readStructBegin(isBase);
        while (true) {
            fieldTag = reader.readFieldBegin();
            if (fieldTag.type == BondDataType.BT_STOP || fieldTag.type == BondDataType.BT_STOP_BASE) break;
            switch (fieldTag.id) {
                case 10: {
                    this.ver = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 20: {
                    this.name = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 30: {
                    this.time = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 40: {
                    this.popSample = ReadHelper.readDouble((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 50: {
                    this.epoch = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 60: {
                    this.seqNum = ReadHelper.readInt64((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 70: {
                    this.iKey = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 80: {
                    this.flags = ReadHelper.readInt64((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 90: {
                    this.os = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 100: {
                    this.osVer = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 110: {
                    this.appId = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 120: {
                    this.appVer = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 130: {
                    this.cV = ReadHelper.readString((ProtocolReader)reader, (BondDataType)fieldTag.type);
                    break;
                }
                case 500: {
                    this.readFieldImpl_tags(reader, fieldTag.type);
                    break;
                }
                case 510: {
                    this.readFieldImpl_ext(reader, fieldTag.type);
                    break;
                }
                case 999: {
                    ReadHelper.validateType((BondDataType)fieldTag.type, (BondDataType)BondDataType.BT_STRUCT);
                    this.data.readNested(reader);
                    break;
                }
                default: {
                    reader.skip(fieldTag.type);
                }
            }
            reader.readFieldEnd();
        }
        boolean isPartial = fieldTag.type == BondDataType.BT_STOP_BASE;
        reader.readStructEnd();
        return isPartial;
    }

    private void readFieldImpl_tags(ProtocolReader reader, BondDataType typeInPayload) throws IOException {
        ReadHelper.validateType((BondDataType)typeInPayload, (BondDataType)BondDataType.BT_MAP);
        ProtocolReader.MapTag tag1 = reader.readMapContainerBegin();
        for (int i2 = 0; i2 < tag1.size; ++i2) {
            String key3 = "";
            String val4 = "";
            key3 = ReadHelper.readString((ProtocolReader)reader, (BondDataType)tag1.keyType);
            val4 = ReadHelper.readString((ProtocolReader)reader, (BondDataType)tag1.valueType);
            this.tags.put(key3, val4);
        }
        reader.readContainerEnd();
    }

    private void readFieldImpl_ext(ProtocolReader reader, BondDataType typeInPayload) throws IOException {
        ReadHelper.validateType((BondDataType)typeInPayload, (BondDataType)BondDataType.BT_MAP);
        ProtocolReader.MapTag tag1 = reader.readMapContainerBegin();
        ReadHelper.validateType((BondDataType)tag1.valueType, (BondDataType)BondDataType.BT_STRUCT);
        for (int i2 = 0; i2 < tag1.size; ++i2) {
            String key3 = "";
            Bonded val4 = new Bonded();
            key3 = ReadHelper.readString((ProtocolReader)reader, (BondDataType)tag1.keyType);
            val4.readNested(reader);
            this.ext.put(key3, (Bonded<Extension>)val4);
        }
        reader.readContainerEnd();
    }

    public void marshal(ProtocolWriter writer) throws IOException {
        Marshaler.marshal((BondSerializable)this, (ProtocolWriter)writer);
    }

    public void write(ProtocolWriter writer) throws IOException {
        writer.writeBegin();
        ProtocolWriter firstPassWriter = writer.getFirstPassWriter();
        if (firstPassWriter != null) {
            this.writeNested(firstPassWriter, false);
            this.writeNested(writer, false);
        } else {
            this.writeNested(writer, false);
        }
        writer.writeEnd();
    }

    public void writeNested(ProtocolWriter writer, boolean isBase) throws IOException {
        boolean canOmitFields = writer.hasCapability(ProtocolCapability.CAN_OMIT_FIELDS);
        writer.writeStructBegin((BondSerializable)Schema.metadata, isBase);
        writer.writeFieldBegin(BondDataType.BT_STRING, 10, (BondSerializable)Schema.ver_metadata);
        writer.writeString(this.ver);
        writer.writeFieldEnd();
        writer.writeFieldBegin(BondDataType.BT_STRING, 20, (BondSerializable)Schema.name_metadata);
        writer.writeString(this.name);
        writer.writeFieldEnd();
        writer.writeFieldBegin(BondDataType.BT_STRING, 30, (BondSerializable)Schema.time_metadata);
        writer.writeString(this.time);
        writer.writeFieldEnd();
        if (!canOmitFields || this.popSample != Schema.popSample_metadata.getDefault_value().getDouble_value()) {
            writer.writeFieldBegin(BondDataType.BT_DOUBLE, 40, (BondSerializable)Schema.popSample_metadata);
            writer.writeDouble(this.popSample);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_DOUBLE, 40, (BondSerializable)Schema.popSample_metadata);
        }
        if (!canOmitFields || this.epoch != Schema.epoch_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 50, (BondSerializable)Schema.epoch_metadata);
            writer.writeString(this.epoch);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 50, (BondSerializable)Schema.epoch_metadata);
        }
        if (!canOmitFields || this.seqNum != Schema.seqNum_metadata.getDefault_value().getInt_value()) {
            writer.writeFieldBegin(BondDataType.BT_INT64, 60, (BondSerializable)Schema.seqNum_metadata);
            writer.writeInt64(this.seqNum);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_INT64, 60, (BondSerializable)Schema.seqNum_metadata);
        }
        if (!canOmitFields || this.iKey != Schema.iKey_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 70, (BondSerializable)Schema.iKey_metadata);
            writer.writeString(this.iKey);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 70, (BondSerializable)Schema.iKey_metadata);
        }
        if (!canOmitFields || this.flags != Schema.flags_metadata.getDefault_value().getInt_value()) {
            writer.writeFieldBegin(BondDataType.BT_INT64, 80, (BondSerializable)Schema.flags_metadata);
            writer.writeInt64(this.flags);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_INT64, 80, (BondSerializable)Schema.flags_metadata);
        }
        if (!canOmitFields || this.os != Schema.os_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 90, (BondSerializable)Schema.os_metadata);
            writer.writeString(this.os);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 90, (BondSerializable)Schema.os_metadata);
        }
        if (!canOmitFields || this.osVer != Schema.osVer_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 100, (BondSerializable)Schema.osVer_metadata);
            writer.writeString(this.osVer);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 100, (BondSerializable)Schema.osVer_metadata);
        }
        if (!canOmitFields || this.appId != Schema.appId_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 110, (BondSerializable)Schema.appId_metadata);
            writer.writeString(this.appId);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 110, (BondSerializable)Schema.appId_metadata);
        }
        if (!canOmitFields || this.appVer != Schema.appVer_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 120, (BondSerializable)Schema.appVer_metadata);
            writer.writeString(this.appVer);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 120, (BondSerializable)Schema.appVer_metadata);
        }
        if (!canOmitFields || this.cV != Schema.cV_metadata.getDefault_value().getString_value()) {
            writer.writeFieldBegin(BondDataType.BT_STRING, 130, (BondSerializable)Schema.cV_metadata);
            writer.writeString(this.cV);
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_STRING, 130, (BondSerializable)Schema.cV_metadata);
        }
        int size11 = this.tags.size();
        if (!canOmitFields || size11 != 0) {
            writer.writeFieldBegin(BondDataType.BT_MAP, 500, (BondSerializable)Schema.tags_metadata);
            writer.writeContainerBegin(this.tags.size(), BondDataType.BT_STRING, BondDataType.BT_STRING);
            for (Map.Entry<String, String> e12 : this.tags.entrySet()) {
                writer.writeString(e12.getKey());
                writer.writeString(e12.getValue());
            }
            writer.writeContainerEnd();
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_MAP, 500, (BondSerializable)Schema.tags_metadata);
        }
        int size13 = this.ext.size();
        if (!canOmitFields || size13 != 0) {
            writer.writeFieldBegin(BondDataType.BT_MAP, 510, (BondSerializable)Schema.ext_metadata);
            writer.writeContainerBegin(this.ext.size(), BondDataType.BT_STRING, BondDataType.BT_STRUCT);
            for (Map.Entry<String, Bonded<Extension>> e14 : this.ext.entrySet()) {
                writer.writeString(e14.getKey());
                e14.getValue().writeNested(writer, false);
            }
            writer.writeContainerEnd();
            writer.writeFieldEnd();
        } else {
            writer.writeFieldOmitted(BondDataType.BT_MAP, 510, (BondSerializable)Schema.ext_metadata);
        }
        writer.writeFieldBegin(BondDataType.BT_STRUCT, 999, (BondSerializable)Schema.data_metadata);
        this.data.writeNested(writer, false);
        writer.writeFieldEnd();
        writer.writeStructEnd(isBase);
    }

    public boolean memberwiseCompare(Object obj) {
        if (obj == null) {
            return false;
        }
        Envelope that = (Envelope)obj;
        return this.memberwiseCompareQuick(that) && this.memberwiseCompareDeep(that);
    }

    protected boolean memberwiseCompareQuick(Envelope that) {
        boolean equals = true;
        equals = equals && this.ver == null == (that.ver == null);
        boolean bl = equals = equals && (this.ver == null || this.ver.length() == that.ver.length());
        equals = equals && this.name == null == (that.name == null);
        boolean bl2 = equals = equals && (this.name == null || this.name.length() == that.name.length());
        equals = equals && this.time == null == (that.time == null);
        boolean bl3 = equals = equals && (this.time == null || this.time.length() == that.time.length());
        boolean bl4 = equals && (Double.isNaN(this.popSample) ? Double.isNaN(that.popSample) : this.popSample == that.popSample) ? true : (equals = false);
        equals = equals && this.epoch == null == (that.epoch == null);
        equals = equals && (this.epoch == null || this.epoch.length() == that.epoch.length());
        boolean bl5 = equals = equals && this.seqNum == that.seqNum;
        equals = equals && this.iKey == null == (that.iKey == null);
        equals = equals && (this.iKey == null || this.iKey.length() == that.iKey.length());
        boolean bl6 = equals = equals && this.flags == that.flags;
        equals = equals && this.os == null == (that.os == null);
        boolean bl7 = equals = equals && (this.os == null || this.os.length() == that.os.length());
        equals = equals && this.osVer == null == (that.osVer == null);
        boolean bl8 = equals = equals && (this.osVer == null || this.osVer.length() == that.osVer.length());
        equals = equals && this.appId == null == (that.appId == null);
        boolean bl9 = equals = equals && (this.appId == null || this.appId.length() == that.appId.length());
        equals = equals && this.appVer == null == (that.appVer == null);
        boolean bl10 = equals = equals && (this.appVer == null || this.appVer.length() == that.appVer.length());
        equals = equals && this.cV == null == (that.cV == null);
        boolean bl11 = equals = equals && (this.cV == null || this.cV.length() == that.cV.length());
        equals = equals && this.tags == null == (that.tags == null);
        boolean bl12 = equals = equals && (this.tags == null || this.tags.size() == that.tags.size());
        equals = equals && this.ext == null == (that.ext == null);
        equals = equals && (this.ext == null || this.ext.size() == that.ext.size());
        return equals;
    }

    protected boolean memberwiseCompareDeep(Envelope that) {
        boolean equals = true;
        equals = equals && (this.ver == null || this.ver.equals(that.ver));
        equals = equals && (this.name == null || this.name.equals(that.name));
        equals = equals && (this.time == null || this.time.equals(that.time));
        equals = equals && (this.epoch == null || this.epoch.equals(that.epoch));
        equals = equals && (this.iKey == null || this.iKey.equals(that.iKey));
        equals = equals && (this.os == null || this.os.equals(that.os));
        equals = equals && (this.osVer == null || this.osVer.equals(that.osVer));
        equals = equals && (this.appId == null || this.appId.equals(that.appId));
        equals = equals && (this.appVer == null || this.appVer.equals(that.appVer));
        boolean bl = equals = equals && (this.cV == null || this.cV.equals(that.cV));
        if (equals && this.tags != null && this.tags.size() != 0) {
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                String val1 = entry.getValue();
                String val2 = that.tags.get(entry.getKey());
                boolean bl2 = equals = equals && that.tags.containsKey(entry.getKey());
                if (equals) {
                    equals = equals && val1 == null == (val2 == null);
                    equals = equals && (val1 == null || val1.length() == val2.length());
                    boolean bl3 = equals = equals && (val1 == null || val1.equals(val2));
                }
                if (equals) continue;
                break;
            }
        }
        if (equals && this.ext != null && this.ext.size() != 0) {
            for (Map.Entry<String, String> entry : this.ext.entrySet()) {
                Bonded val4 = (Bonded)entry.getValue();
                Bonded<Extension> val5 = that.ext.get(entry.getKey());
                boolean bl4 = equals = equals && that.ext.containsKey(entry.getKey());
                if (equals) {
                    equals = equals && val4 == null == (val5 == null);
                    boolean bl5 = equals = equals && (val4 == null || val4.memberwiseCompare(val5));
                }
                if (equals) continue;
                break;
            }
        }
        equals = equals && (this.data == null || this.data.memberwiseCompare(that.data));
        return equals;
    }

    public static class Schema {
        public static final SchemaDef schemaDef;
        public static final Metadata metadata;
        private static final Metadata ver_metadata;
        private static final Metadata name_metadata;
        private static final Metadata time_metadata;
        private static final Metadata popSample_metadata;
        private static final Metadata epoch_metadata;
        private static final Metadata seqNum_metadata;
        private static final Metadata iKey_metadata;
        private static final Metadata flags_metadata;
        private static final Metadata os_metadata;
        private static final Metadata osVer_metadata;
        private static final Metadata appId_metadata;
        private static final Metadata appVer_metadata;
        private static final Metadata cV_metadata;
        private static final Metadata tags_metadata;
        private static final Metadata ext_metadata;
        private static final Metadata data_metadata;

        public static TypeDef getTypeDef(SchemaDef schema) {
            TypeDef type = new TypeDef();
            type.setId(BondDataType.BT_STRUCT);
            type.setStruct_def(Schema.getStructDef(schema));
            return type;
        }

        private static short getStructDef(SchemaDef schema) {
            short pos;
            for (pos = 0; pos < schema.getStructs().size(); pos = (short)(pos + 1)) {
                if (((StructDef)schema.getStructs().get(pos)).getMetadata() != metadata) continue;
                return pos;
            }
            StructDef structDef = new StructDef();
            schema.getStructs().add(structDef);
            structDef.setMetadata(metadata);
            FieldDef field = new FieldDef();
            field.setId((short)10);
            field.setMetadata(ver_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)20);
            field.setMetadata(name_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)30);
            field.setMetadata(time_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)40);
            field.setMetadata(popSample_metadata);
            field.getType().setId(BondDataType.BT_DOUBLE);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)50);
            field.setMetadata(epoch_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)60);
            field.setMetadata(seqNum_metadata);
            field.getType().setId(BondDataType.BT_INT64);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)70);
            field.setMetadata(iKey_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)80);
            field.setMetadata(flags_metadata);
            field.getType().setId(BondDataType.BT_INT64);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)90);
            field.setMetadata(os_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)100);
            field.setMetadata(osVer_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)110);
            field.setMetadata(appId_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)120);
            field.setMetadata(appVer_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)130);
            field.setMetadata(cV_metadata);
            field.getType().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)500);
            field.setMetadata(tags_metadata);
            field.getType().setId(BondDataType.BT_MAP);
            field.getType().setKey(new TypeDef());
            field.getType().setElement(new TypeDef());
            field.getType().getKey().setId(BondDataType.BT_STRING);
            field.getType().getElement().setId(BondDataType.BT_STRING);
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)510);
            field.setMetadata(ext_metadata);
            field.getType().setId(BondDataType.BT_MAP);
            field.getType().setKey(new TypeDef());
            field.getType().setElement(new TypeDef());
            field.getType().getKey().setId(BondDataType.BT_STRING);
            field.getType().setElement(Extension.Schema.getTypeDef(schema));
            structDef.getFields().add(field);
            field = new FieldDef();
            field.setId((short)999);
            field.setMetadata(data_metadata);
            field.setType(Base.Schema.getTypeDef(schema));
            structDef.getFields().add(field);
            return pos;
        }

        static {
            metadata = new Metadata();
            metadata.setName("Envelope");
            metadata.setQualified_name("Microsoft.Telemetry.Envelope");
            metadata.getAttributes().put("Description", "System variables for a telemetry item (Part A)");
            ver_metadata = new Metadata();
            ver_metadata.setName("ver");
            ver_metadata.setModifier(Modifier.Required);
            ver_metadata.getAttributes().put("Name", "SchemaVersion");
            name_metadata = new Metadata();
            name_metadata.setName("name");
            name_metadata.setModifier(Modifier.Required);
            name_metadata.getAttributes().put("Name", "DataTypeName");
            time_metadata = new Metadata();
            time_metadata.setName("time");
            time_metadata.setModifier(Modifier.Required);
            time_metadata.getAttributes().put("Name", "DateTime");
            popSample_metadata = new Metadata();
            popSample_metadata.setName("popSample");
            popSample_metadata.getAttributes().put("Name", "SamplingRate");
            popSample_metadata.getDefault_value().setDouble_value(100.0);
            epoch_metadata = new Metadata();
            epoch_metadata.setName("epoch");
            epoch_metadata.getAttributes().put("Name", "Epoch");
            seqNum_metadata = new Metadata();
            seqNum_metadata.setName("seqNum");
            seqNum_metadata.getAttributes().put("Name", "SequenceNumber");
            seqNum_metadata.getDefault_value().setInt_value(0L);
            iKey_metadata = new Metadata();
            iKey_metadata.setName("iKey");
            iKey_metadata.getAttributes().put("Name", "InstrumentationKey");
            flags_metadata = new Metadata();
            flags_metadata.setName("flags");
            flags_metadata.getAttributes().put("Name", "TelemetryProperties");
            flags_metadata.getDefault_value().setInt_value(0L);
            os_metadata = new Metadata();
            os_metadata.setName("os");
            os_metadata.getAttributes().put("Name", "OsPlatform");
            osVer_metadata = new Metadata();
            osVer_metadata.setName("osVer");
            osVer_metadata.getAttributes().put("Name", "OsVersion");
            appId_metadata = new Metadata();
            appId_metadata.setName("appId");
            appId_metadata.getAttributes().put("Name", "ApplicationId");
            appVer_metadata = new Metadata();
            appVer_metadata.setName("appVer");
            appVer_metadata.getAttributes().put("Name", "ApplicationVersion");
            cV_metadata = new Metadata();
            cV_metadata.setName("cV");
            cV_metadata.getAttributes().put("Name", "CorrelationVector");
            tags_metadata = new Metadata();
            tags_metadata.setName("tags");
            tags_metadata.getAttributes().put("Name", "Tags");
            ext_metadata = new Metadata();
            ext_metadata.setName("ext");
            ext_metadata.getAttributes().put("Name", "Extensions");
            data_metadata = new Metadata();
            data_metadata.setName("data");
            data_metadata.getAttributes().put("Name", "TelemetryData");
            schemaDef = new SchemaDef();
            schemaDef.setRoot(Schema.getTypeDef(schemaDef));
        }
    }
}

