/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.userdata.usernotifications;

import android.support.annotation.IntRange;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeEvent;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectEventListener;
import com.microsoft.connecteddevices.NativeObjectListAsyncOperation;
import com.microsoft.connecteddevices.userdata.usernotifications.UserNotification;
import com.microsoft.connecteddevices.userdata.usernotifications.UserNotificationReaderDataChangedEventArgs;
import java.util.List;

@Keep
public class UserNotificationReader
extends NativeBase {
    private Event<UserNotificationReader, UserNotificationReaderDataChangedEventArgs> mDataChanged = new NativeEvent<UserNotificationReader, UserNotificationReaderDataChangedEventArgs>(this, this::addDataChangedListenerNative, this::removeDataChangedListenerNative, UserNotificationReader::new, UserNotificationReaderDataChangedEventArgs::new);

    protected UserNotificationReader(NativeObject nativeObject) {
        super(nativeObject);
    }

    @NonNull
    public AsyncOperation<List<UserNotification>> readBatchAsync(@IntRange(from=0L) long maxBatchSize) {
        if (maxBatchSize < 0L) {
            throw new IllegalArgumentException("Maximum batch size must be non-negative");
        }
        NativeObjectListAsyncOperation<Object> operation = new NativeObjectListAsyncOperation<Object>(UserNotification::new);
        this.readBatchAsyncNative(this.getNativePointer(), maxBatchSize, operation);
        return operation;
    }

    @NonNull
    public String getSerializedState() {
        return this.getSerializedStateNative(this.getNativePointer());
    }

    @NonNull
    public Event<UserNotificationReader, UserNotificationReaderDataChangedEventArgs> dataChanged() {
        return this.mDataChanged;
    }

    private native void readBatchAsyncNative(long var1, long var3, AsyncOperation<List<UserNotification>> var5);

    private native String getSerializedStateNative(long var1);

    private native long addDataChangedListenerNative(long var1, NativeObjectEventListener<UserNotificationReader, UserNotificationReaderDataChangedEventArgs> var3);

    private native void removeDataChangedListenerNative(long var1, long var3);
}

