/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.userdata.useractivities;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.NativeObjectListAsyncOperation;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.userdata.UserDataFeed;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import com.microsoft.connecteddevices.userdata.useractivities.UserActivity;
import com.microsoft.connecteddevices.userdata.useractivities.UserActivityChannelSyncScope;
import com.microsoft.connecteddevices.userdata.useractivities.UserActivitySessionHistoryItem;
import java.util.Date;
import java.util.List;

@Keep
public final class UserActivityChannel
extends NativeBase {
    UserActivityChannel(NativeObject obj) {
        super(obj);
    }

    public UserActivityChannel(@NonNull UserDataFeed userDataFeed) {
        super(UserActivityChannel.createInstanceNative(NativeUtils.getNativePointer(userDataFeed)));
    }

    @NonNull
    public AsyncOperation<UserActivity> getOrCreateUserActivityAsync(@NonNull String activityId) {
        NativeObjectAsyncOperation<UserActivity> callback = new NativeObjectAsyncOperation<UserActivity>(UserActivity::new);
        this.getOrCreateUserActivityAsyncNative(this.getNativePointer(), activityId, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<Void> deleteActivityAsync(@NonNull String activityId) {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.deleteActivityAsyncNative(this.getNativePointer(), activityId, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<Void> deleteAllActivitiesAsync() {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.deleteAllActivitiesAsyncNative(this.getNativePointer(), callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<List<UserActivitySessionHistoryItem>> getRecentUserActivitiesAsync(int maxUniqueActivities) {
        NativeObjectListAsyncOperation<Object> callback = new NativeObjectListAsyncOperation<Object>(UserActivitySessionHistoryItem::new);
        this.getRecentUserActivitiesAsyncNative(this.getNativePointer(), maxUniqueActivities, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<List<UserActivitySessionHistoryItem>> getSessionHistoryItemsForUserActivityAsync(@NonNull String activityId, @NonNull Date startTime) {
        NativeObjectListAsyncOperation<Object> callback = new NativeObjectListAsyncOperation<Object>(UserActivitySessionHistoryItem::new);
        this.getSessionHistoryItemsForUserActivityAsyncNative(this.getNativePointer(), activityId, startTime, callback);
        return callback;
    }

    public void setAppDisplayName(@Nullable String appDisplayName) {
        this.setAppDisplayNameNative(this.getNativePointer(), appDisplayName);
    }

    @Nullable
    public String getAppDisplayName() {
        return this.getAppDisplayNameNative(this.getNativePointer());
    }

    @NonNull
    public static UserDataFeedSyncScope getSyncScope() {
        return NativeObject.toSpecific(UserActivityChannel.getSyncScopeNative(), UserActivityChannelSyncScope::new);
    }

    private native void getOrCreateUserActivityAsyncNative(long var1, String var3, AsyncOperation<UserActivity> var4);

    private native void deleteActivityAsyncNative(long var1, String var3, AsyncOperation<Void> var4);

    private native void deleteAllActivitiesAsyncNative(long var1, AsyncOperation<Void> var3);

    private native void getRecentUserActivitiesAsyncNative(long var1, int var3, AsyncOperation<List<UserActivitySessionHistoryItem>> var4);

    private native void getSessionHistoryItemsForUserActivityAsyncNative(long var1, String var3, Date var4, AsyncOperation<List<UserActivitySessionHistoryItem>> var5);

    private native void setAppDisplayNameNative(long var1, String var3);

    private native String getAppDisplayNameNative(long var1);

    private static native NativeObject createInstanceNative(long var0);

    private static native NativeObject getSyncScopeNative();
}

