/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems.commanding.nearshare;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.AsyncOperationWithProgress;
import com.microsoft.connecteddevices.CancellationToken;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeEnumAsyncOperation;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.remotesystems.commanding.RemoteSystemConnectionRequest;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareFileProvider;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareProgress;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareSenderEnumAsyncOperation;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareStatus;

@Keep
public final class NearShareSender
extends NativeBase {
    NearShareSender(NativeObject nativeObject) {
        super(nativeObject);
    }

    public NearShareSender() {
        super(NearShareSender.createInstanceNative());
    }

    @NonNull
    public AsyncOperation<NearShareStatus> sendUriAsync(RemoteSystemConnectionRequest remoteSystemConnectionRequest, String uri) {
        NativeEnumAsyncOperation<NearShareStatus> operation = new NativeEnumAsyncOperation<NearShareStatus>(NearShareStatus::fromInt);
        this.sendUriAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(remoteSystemConnectionRequest), uri, operation);
        return operation;
    }

    @NonNull
    public AsyncOperationWithProgress<NearShareStatus, NearShareProgress> sendFilesAsync(RemoteSystemConnectionRequest remoteSystemConnectionRequest, NearShareFileProvider[] files) {
        NearShareSenderEnumAsyncOperation<NearShareStatus, NearShareProgress> operation = new NearShareSenderEnumAsyncOperation<NearShareStatus, NearShareProgress>(NearShareStatus::fromInt);
        CancellationToken cancellationToken = new CancellationToken(this.sendFilesAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(remoteSystemConnectionRequest), files, operation, p -> operation.notifyListeners(p)));
        operation.setCancellationToken(cancellationToken);
        return operation;
    }

    @NonNull
    public AsyncOperationWithProgress<NearShareStatus, NearShareProgress> sendFileAsync(RemoteSystemConnectionRequest remoteSystemConnectionRequest, NearShareFileProvider file) {
        NearShareSenderEnumAsyncOperation<NearShareStatus, NearShareProgress> operation = new NearShareSenderEnumAsyncOperation<NearShareStatus, NearShareProgress>(NearShareStatus::fromInt);
        CancellationToken cancellationToken = new CancellationToken(this.sendFileAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(remoteSystemConnectionRequest), file, operation, p -> operation.notifyListeners(p)));
        operation.setCancellationToken(cancellationToken);
        return operation;
    }

    public boolean isNearShareSupported(RemoteSystemConnectionRequest remoteSystemConnectionRequest) {
        return NearShareSender.isNearShareSupportedNative(remoteSystemConnectionRequest.getNativePointer());
    }

    private static native NativeObject createInstanceNative();

    private static native boolean isNearShareSupportedNative(long var0);

    private native void sendUriAsyncNative(long var1, long var3, String var5, AsyncOperation<NearShareStatus> var6);

    private native NativeObject sendFilesAsyncNative(long var1, long var3, NearShareFileProvider[] var5, AsyncOperation<NearShareStatus> var6, ProgressCallback var7);

    private native NativeObject sendFileAsyncNative(long var1, long var3, NearShareFileProvider var5, AsyncOperation<NearShareStatus> var6, ProgressCallback var7);

    @FunctionalInterface
    @Keep
    private static interface ProgressCallback {
        public void onProgress(NearShareProgress var1);
    }
}

