/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.NativeBase;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeUtils {
    private NativeUtils() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> long[] convertToNativeArray(T[] bases) {
        if (bases == null) {
            return null;
        }
        long[] toReturn = new long[bases.length];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = NativeUtils.getNativePointerFromInterface(bases[i]);
        }
        return toReturn;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> long[] convertToNativeArray(Collection<T> bases, Class<T> type) {
        return NativeUtils.convertToNativeArray(NativeUtils.convertCollectionToArray(bases, type));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> T[] convertCollectionToArray(Collection<? extends T> collection, Class<T> type) {
        if (collection == null) {
            return NativeUtils.newArray(type, 0);
        }
        T[] array = NativeUtils.newArray(type, collection.size());
        return collection.toArray(array);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T extends Enum<T>> int convertToNativeEnum(EnumSet<T> enumSet, FromEnumCreator<T> creator) {
        int nativeEnum = 0;
        for (Enum value : enumSet) {
            nativeEnum |= creator.create(value);
        }
        return nativeEnum;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T extends Enum<T>> EnumSet<T> convertToEnumSet(int value, Class<T> enumClass, ToEnumCreator<T> creator) {
        EnumSet<T> result = EnumSet.noneOf(enumClass);
        for (int flagValue = 1; value >= flagValue && flagValue != 0; flagValue <<= 1) {
            if ((value & flagValue) == 0) continue;
            result.add(creator.create(flagValue));
        }
        return result;
    }

    static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void registerContext(Context context) {
        NativeUtils.registerContextNative(context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static long getNativePointer(NativeBase projectedObject) {
        return projectedObject == null ? 0L : projectedObject.getNativePointer();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> long getNativePointerFromInterface(T interfaceObject) {
        return interfaceObject instanceof NativeBase ? NativeUtils.getNativePointer((NativeBase)interfaceObject) : 0L;
    }

    private static native void registerContextNative(Context var0);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface FromEnumCreator<T extends Enum<T>> {
        public int create(T var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ToEnumCreator<T extends Enum<T>> {
        public T create(int var1);
    }
}

