/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.ConnectedDevicesAccount;
import com.microsoft.connecteddevices.ConnectedDevicesNotificationRegistration;
import com.microsoft.connecteddevices.ConnectedDevicesNotificationRegistrationState;
import com.microsoft.connecteddevices.ConnectedDevicesNotificationRegistrationStateChangedEventArgs;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeBooleanAsyncOperation;
import com.microsoft.connecteddevices.NativeEvent;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectEventListener;
import com.microsoft.connecteddevices.NativeUtils;

@Keep
public final class ConnectedDevicesNotificationRegistrationManager
extends NativeBase {
    private Event<ConnectedDevicesNotificationRegistrationManager, ConnectedDevicesNotificationRegistrationStateChangedEventArgs> mStateChanged = new NativeEvent<ConnectedDevicesNotificationRegistrationManager, ConnectedDevicesNotificationRegistrationStateChangedEventArgs>(this, this::addStateChangedListenerNative, this::removeStateChangedListenerNative, ConnectedDevicesNotificationRegistrationManager::new, obj -> NativeObject.toSpecific(obj, ConnectedDevicesNotificationRegistrationStateChangedEventArgs.class));

    ConnectedDevicesNotificationRegistrationManager(NativeObject nativeObject) {
        super(nativeObject);
    }

    @NonNull
    public AsyncOperation<Boolean> registerForAccountAsync(@NonNull ConnectedDevicesAccount account, @NonNull ConnectedDevicesNotificationRegistration notificationRegistration) {
        NativeBooleanAsyncOperation operation = new NativeBooleanAsyncOperation();
        this.registerForAccountAsyncNative(this.getNativePointer(), account.getNativePointer(), NativeUtils.getNativePointer(notificationRegistration), operation);
        return operation;
    }

    @NonNull
    public Event<ConnectedDevicesNotificationRegistrationManager, ConnectedDevicesNotificationRegistrationStateChangedEventArgs> notificationRegistrationStateChanged() {
        return this.mStateChanged;
    }

    @NonNull
    public ConnectedDevicesNotificationRegistrationState getNotificationRegistrationStateForAccount(ConnectedDevicesAccount account) {
        return ConnectedDevicesNotificationRegistrationState.fromInt(this.getNotificationRegistrationStateForAccountNative(this.getNativePointer(), account.getNativePointer()));
    }

    private native void registerForAccountAsyncNative(long var1, long var3, long var5, AsyncOperation<Boolean> var7);

    private native long addStateChangedListenerNative(long var1, NativeObjectEventListener<ConnectedDevicesNotificationRegistrationManager, ConnectedDevicesNotificationRegistrationStateChangedEventArgs> var3);

    private native void removeStateChangedListenerNative(long var1, long var3);

    private native int getNotificationRegistrationStateForAccountNative(long var1, long var3);
}

