/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.AbstractHandler;
import com.microsoft.cll.android.EventSerializer;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.IStorage;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.SynchronizedArrayList;
import com.microsoft.cll.android.Tuple;
import com.microsoft.telemetry.IJsonSerializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class FileStorage
implements IStorage {
    protected static final SynchronizedArrayList<String> fileLockList = new SynchronizedArrayList();
    private final String TAG = "AndroidCll-FileStorage";
    private final ILogger logger;
    private final EventSerializer serializer;
    private boolean isOpen;
    private boolean isWritable;
    private int eventsWritten;
    private long fileSize;
    private String filePathAndName;
    private FileReader inputFile;
    private FileWriter outputFile;
    private BufferedReader reader;
    private AbstractHandler parent;

    public FileStorage(String fileExtension, ILogger logger, String filePath, AbstractHandler parent) {
        this.eventsWritten = 0;
        this.fileSize = 0L;
        this.filePathAndName = filePath + File.separator + UUID.randomUUID() + fileExtension;
        this.logger = logger;
        this.serializer = new EventSerializer(logger);
        this.parent = parent;
        int tries = 1;
        while (!this.openFile()) {
            this.filePathAndName = filePath + "/" + UUID.randomUUID() + fileExtension;
            if (++tries < 5) continue;
            logger.error("AndroidCll-FileStorage", "Could not create a file");
            return;
        }
    }

    public FileStorage(ILogger logger, String filePathAndName, AbstractHandler parent) throws Exception {
        this.logger = logger;
        this.serializer = new EventSerializer(logger);
        this.filePathAndName = filePathAndName;
        this.parent = parent;
        if (fileLockList.contains(filePathAndName)) {
            throw new Exception("Could not get lock for file");
        }
    }

    @Override
    public void add(IJsonSerializable event) throws FileFullException, IOException {
        String serializedEvent = this.serializer.serialize(event);
        this.add(new Tuple<String, Object>(serializedEvent, null));
    }

    @Override
    public void add(Tuple<String, List<String>> serializedEvent) throws FileFullException, IOException {
        if (!this.isOpen || !this.isWritable) {
            this.logger.warn("AndroidCll-FileStorage", "This file is not open or not writable");
            return;
        }
        if (!this.canAdd(serializedEvent)) {
            throw new FileFullException("The file is already full!");
        }
        if (serializedEvent.b != null) {
            for (String id : (List)serializedEvent.b) {
                this.outputFile.write("x:" + id + "\r\n");
            }
        }
        this.outputFile.write((String)serializedEvent.a);
        ++this.eventsWritten;
        this.fileSize += (long)((String)serializedEvent.a).length();
    }

    @Override
    public boolean canAdd(IJsonSerializable event) {
        String serializedEvent = this.serializer.serialize(event);
        return this.canAdd(new Tuple<String, Object>(serializedEvent, null));
    }

    @Override
    public boolean canAdd(Tuple<String, List<String>> event) {
        if (!this.isOpen || !this.isWritable) {
            this.logger.warn("AndroidCll-FileStorage", "This file is not open or not writable");
            return false;
        }
        int serializedSize = ((String)event.a).length();
        return this.eventsWritten < SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSPERPOST) && (long)serializedSize + this.fileSize < (long)SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES);
    }

    @Override
    public List<Tuple<String, List<String>>> drain() {
        ArrayList<Tuple<String, List<String>>> drainedQueue = new ArrayList<Tuple<String, List<String>>>();
        if (!this.isOpen) {
            try {
                if (!this.openFile()) {
                    return drainedQueue;
                }
            }
            catch (Exception e) {
                this.logger.error("AndroidCll-FileStorage", "Error opening file");
                return drainedQueue;
            }
        }
        try {
            String input = this.reader.readLine();
            ArrayList<String> ids = new ArrayList<String>();
            while (input != null) {
                if (input.startsWith("x:")) {
                    ids.add(input.substring(2));
                } else if (ids.size() > 0) {
                    drainedQueue.add(new Tuple(input, ids));
                    ids = new ArrayList();
                } else {
                    drainedQueue.add(new Tuple<String, Object>(input, null));
                }
                input = this.reader.readLine();
            }
        }
        catch (Exception e) {
            this.logger.error("AndroidCll-FileStorage", "Error reading from input file");
        }
        this.logger.info("AndroidCll-FileStorage", "Read " + drainedQueue.size() + " events from file");
        return drainedQueue;
    }

    @Override
    public long size() {
        if (!this.isOpen) {
            File f = new File(this.filePathAndName);
            return f.length();
        }
        return this.fileSize;
    }

    @Override
    public void discard() {
        this.logger.info("AndroidCll-FileStorage", "Discarding file");
        this.close();
        this.parent.dispose(this);
        File f = new File(this.filePathAndName);
        f.delete();
    }

    public void flush() {
        if (!this.isOpen || !this.isWritable) {
            return;
        }
        try {
            this.outputFile.flush();
        }
        catch (Exception e) {
            this.logger.error("AndroidCll-FileStorage", "Could not flush file");
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.flush();
            fileLockList.remove(this.filePathAndName);
            try {
                if (this.isWritable) {
                    this.outputFile.close();
                } else {
                    this.inputFile.close();
                    this.reader.close();
                }
                this.isOpen = false;
            }
            catch (Exception e) {
                this.logger.error("AndroidCll-FileStorage", "Error when closing file");
            }
        }
    }

    private boolean openFile() {
        boolean lockResult = this.getLock();
        if (!lockResult) {
            this.logger.info("AndroidCll-FileStorage", "Could not get lock for file");
            return false;
        }
        File f = new File(this.filePathAndName);
        boolean doesFileExist = f.exists();
        if (doesFileExist) {
            this.isWritable = false;
            try {
                this.inputFile = new FileReader(this.filePathAndName);
                this.reader = new BufferedReader(this.inputFile);
                this.fileSize = f.length();
            }
            catch (IOException e) {
                this.logger.error("AndroidCll-FileStorage", "Event file was not found");
                return false;
            }
        }
        this.isWritable = true;
        this.logger.info("AndroidCll-FileStorage", "Creating new file");
        try {
            this.outputFile = new FileWriter(this.filePathAndName);
        }
        catch (IOException e) {
            this.logger.error("AndroidCll-FileStorage", "Error opening file");
            return false;
        }
        this.isOpen = true;
        return true;
    }

    private boolean getLock() {
        return fileLockList.add(this.filePathAndName);
    }

    class FileFullException
    extends Exception {
        public FileFullException(String message) {
            super(message);
        }
    }
}

