/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import android.util.Base64;
import com.microsoft.bond.BondBlob;
import com.microsoft.bond.BondDataType;
import com.microsoft.bond.BondSerializable;
import com.microsoft.bond.Metadata;
import com.microsoft.bond.ProtocolCapability;
import com.microsoft.bond.ProtocolWriter;
import java.io.IOException;
import java.util.Stack;

public class JsonProtocol
extends ProtocolWriter {
    private static final char ESCAPE_CHAR = '\\';
    private static final String NUMERIC_ESCAPE_STRING = "\\u";
    private static final Stack<BondDataType> keyTypes = new Stack();
    private static final Stack<BondDataType> valueTypes = new Stack();
    private static final Stack<Boolean> inContainerStack = new Stack();
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final StringBuilder stringBuilder;
    private final Stack<Boolean> containerIsTyped = new Stack();
    private boolean inContainer;
    private boolean isKey;

    public JsonProtocol(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    public void writeVersion() throws IOException {
    }

    public void writeBegin() {
    }

    public void writeEnd() {
    }

    public void writeStructBegin(BondSerializable metadata, boolean isBase) {
        if (!isBase) {
            this.stringBuilder.append('{');
        }
        inContainerStack.push(false);
    }

    public void writeStructEnd(boolean isBase) {
        if (!isBase) {
            this.removeLastComma();
            this.stringBuilder.append('}');
            if (inContainerStack.size() > 1) {
                this.appendComma();
            }
        }
        inContainerStack.pop();
    }

    public void writeFieldBegin(BondDataType type, int id, BondSerializable metadata) throws IOException {
        Metadata bondMetadata;
        Metadata metadata2 = bondMetadata = metadata instanceof Metadata ? (Metadata)metadata : null;
        if (bondMetadata != null) {
            this.writeJsonFieldName(bondMetadata.getName());
        }
    }

    public void writeFieldEnd() {
        this.appendComma();
    }

    public void writeFieldOmitted(BondDataType type, int id, BondSerializable metadata) throws IOException {
    }

    public void writeContainerBegin(int i, BondDataType bondDataType) throws IOException {
        this.stringBuilder.append('[');
        this.containerIsTyped.push(Boolean.TRUE);
        inContainerStack.push(true);
    }

    public void writeContainerBegin(int i, BondDataType keyType, BondDataType valueType) throws IOException {
        this.stringBuilder.append('{');
        this.containerIsTyped.push(Boolean.FALSE);
        this.inContainer = true;
        this.isKey = true;
        keyTypes.push(keyType);
        valueTypes.push(valueType);
        inContainerStack.push(true);
    }

    public void writeContainerEnd() throws IOException {
        this.removeLastComma();
        this.stringBuilder.append(this.containerIsTyped.pop() != false ? (char)']' : '}');
        this.inContainer = false;
        this.isKey = false;
        keyTypes.pop();
        inContainerStack.pop();
    }

    public void writeBool(boolean b) throws IOException {
        this.stringBuilder.append(b);
        this.appendInContainer();
    }

    public void writeString(String s) throws IOException {
        if (inContainerStack.peek().booleanValue() && !keyTypes.empty() && keyTypes.peek() == BondDataType.BT_STRING) {
            if (this.isKey) {
                this.writeJsonFieldName(s);
            } else if (!this.isKey) {
                this.actuallyWriteString(s);
            }
            if (valueTypes.peek() == BondDataType.BT_STRING) {
                this.isKey = !this.isKey;
            }
        } else {
            this.actuallyWriteString(s);
        }
    }

    private void actuallyWriteString(String s) {
        if (s == null) {
            this.appendEscaped("null");
            this.appendInContainer();
        } else {
            this.stringBuilder.append('\"');
            this.appendEscaped(s);
            this.stringBuilder.append('\"');
            this.appendInContainer();
        }
    }

    public void writeWString(String s) throws IOException {
        this.writeString(s);
    }

    public void writeFloat(float v) throws IOException {
        this.stringBuilder.append(v);
        this.appendInContainer();
    }

    public void writeDouble(double v) throws IOException {
        this.stringBuilder.append(v);
        this.appendInContainer();
    }

    public void writeBlob(BondBlob bondBlob) throws IOException {
        this.stringBuilder.append(Base64.encode((byte[])bondBlob.getBuffer(), (int)0));
        this.appendInContainer();
    }

    public void writeUInt8(byte b) throws IOException {
        this.stringBuilder.append(b);
        this.appendInContainer();
    }

    public void writeUInt16(short i) throws IOException {
        this.stringBuilder.append(i);
        this.appendInContainer();
    }

    public void writeUInt32(int i) throws IOException {
        this.stringBuilder.append(i);
        this.appendInContainer();
    }

    public void writeUInt64(long l) throws IOException {
        this.stringBuilder.append(l);
        this.appendInContainer();
    }

    public void writeInt8(byte b) throws IOException {
        this.stringBuilder.append(b);
        this.appendInContainer();
    }

    public void writeInt16(short i) throws IOException {
        this.stringBuilder.append(i);
        this.appendInContainer();
    }

    public void writeInt32(int i) throws IOException {
        this.stringBuilder.append(i);
        this.appendInContainer();
    }

    public void writeInt64(long l) throws IOException {
        this.stringBuilder.append(l);
        this.appendInContainer();
    }

    public boolean hasCapability(ProtocolCapability capability) {
        if (capability == ProtocolCapability.CAN_OMIT_FIELDS) {
            return true;
        }
        return super.hasCapability(capability);
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private void appendInContainer() {
        if (this.inContainer) {
            this.appendComma();
        }
    }

    private void appendComma() {
        if (this.stringBuilder.length() > 0 && this.stringBuilder.charAt(this.stringBuilder.length() - 1) != ',') {
            this.stringBuilder.append(',');
        }
    }

    private void removeLastComma() {
        if (this.stringBuilder.length() > 0 && this.stringBuilder.charAt(this.stringBuilder.length() - 1) == ',') {
            this.stringBuilder.deleteCharAt(this.stringBuilder.length() - 1);
        }
    }

    private void writeJsonFieldName(String fieldName) {
        this.stringBuilder.append("\"");
        this.appendEscaped(fieldName);
        this.stringBuilder.append("\":");
    }

    private void appendEscaped(String value) {
        int parseIndex = this.stringBuilder.length();
        this.stringBuilder.append(value);
        int length = this.stringBuilder.length();
        block7: while (parseIndex < length) {
            char current = this.stringBuilder.charAt(parseIndex);
            switch (current) {
                case '\\': {
                    this.stringBuilder.insert(parseIndex, '\\');
                    parseIndex += 2;
                    ++length;
                    continue block7;
                }
                case '\n': {
                    this.stringBuilder.insert(parseIndex++, '\\');
                    this.stringBuilder.setCharAt(parseIndex++, 'n');
                    ++length;
                    continue block7;
                }
                case '\r': {
                    this.stringBuilder.insert(parseIndex++, '\\');
                    this.stringBuilder.setCharAt(parseIndex++, 'r');
                    ++length;
                    continue block7;
                }
                case '\t': {
                    this.stringBuilder.insert(parseIndex++, '\\');
                    this.stringBuilder.setCharAt(parseIndex++, 't');
                    ++length;
                    continue block7;
                }
                case '\"': {
                    this.stringBuilder.insert(parseIndex++, '\\');
                    this.stringBuilder.setCharAt(parseIndex++, '\"');
                    ++length;
                    continue block7;
                }
            }
            if (Character.isISOControl(current)) {
                this.stringBuilder.insert(parseIndex, NUMERIC_ESCAPE_STRING);
                parseIndex += NUMERIC_ESCAPE_STRING.length();
                this.stringBuilder.setCharAt(parseIndex++, HEX_CHARACTERS[current >> 12 & 0xF]);
                this.stringBuilder.insert(parseIndex++, HEX_CHARACTERS[current >> 8 & 0xF]);
                this.stringBuilder.insert(parseIndex++, HEX_CHARACTERS[current >> 4 & 0xF]);
                this.stringBuilder.insert(parseIndex++, HEX_CHARACTERS[current & 0xF]);
                length += 3 + NUMERIC_ESCAPE_STRING.length();
                continue;
            }
            ++parseIndex;
        }
    }
}

