/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.AbstractHandler;
import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.CriticalEventHandler;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.EventQueueWriter;
import com.microsoft.cll.android.EventSender;
import com.microsoft.cll.android.FileStorage;
import com.microsoft.cll.android.ICllEvents;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.IStorage;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.NormalEventHandler;
import com.microsoft.cll.android.ScheduledWorker;
import com.microsoft.cll.android.SerializedEvent;
import com.microsoft.cll.android.SettingsStore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class EventHandler
extends ScheduledWorker {
    private final String TAG = "AndroidCll-EventHandler";
    final AbstractHandler criticalHandler;
    final AbstractHandler normalHandler;
    private final ClientTelemetry clientTelemetry;
    private final List<ICllEvents> cllEvents;
    private final ILogger logger;
    private EventSender sender;
    private ITicketCallback ticketCallback;
    private URL endpoint;
    private double sampleId;

    protected EventHandler(ClientTelemetry clientTelemetry, List<ICllEvents> cllEvents, ILogger logger, AbstractHandler normalEventHandler, AbstractHandler criticalEventAbstractHandler) {
        super(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.QUEUEDRAININTERVAL));
        this.clientTelemetry = clientTelemetry;
        this.cllEvents = cllEvents;
        this.logger = logger;
        this.normalHandler = normalEventHandler;
        this.criticalHandler = criticalEventAbstractHandler;
        this.sampleId = -1.0;
    }

    public EventHandler(ClientTelemetry clientTelemetry, List<ICllEvents> cllEvents, ILogger logger, String filePath) {
        super(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.QUEUEDRAININTERVAL));
        this.clientTelemetry = clientTelemetry;
        this.cllEvents = cllEvents;
        this.logger = logger;
        this.criticalHandler = new CriticalEventHandler(logger, filePath, clientTelemetry);
        this.normalHandler = new NormalEventHandler(logger, filePath, clientTelemetry);
        this.sampleId = -1.0;
    }

    @Override
    public void run() {
        if (this.interval != (long)SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.QUEUEDRAININTERVAL)) {
            this.nextExecution.cancel(false);
            this.interval = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.QUEUEDRAININTERVAL);
            this.nextExecution = this.executor.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.SECONDS);
        }
        if (EventQueueWriter.future != null) {
            this.logger.info("AndroidCll-EventHandler", "Retry logic in progress, skipping normal send");
            return;
        }
        this.send();
    }

    @Override
    public void stop() {
        super.stop();
        this.normalHandler.close();
        this.criticalHandler.close();
    }

    protected boolean log(SerializedEvent event, List<String> ids) {
        boolean result;
        boolean isSenderBusy;
        if (this.Filter(event)) {
            return false;
        }
        boolean bl = isSenderBusy = EventQueueWriter.getRunningThreadCount() >= SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXREALTIMETHREADS);
        if (event.getLatency() == EventEnums.Latency.LatencyRealtime && !this.isPaused && !isSenderBusy && (result = this.startEventQueueWriter(new EventQueueWriter(this.endpoint, event, ids, this.clientTelemetry, this.cllEvents, this.logger, this.executor, this, this.ticketCallback)))) {
            return true;
        }
        return this.addToStorage(event, ids);
    }

    protected boolean addToStorage(SerializedEvent event, List<String> ids) {
        switch (event.getPersistence()) {
            default: {
                this.logger.error("AndroidCll-EventHandler", "Unknown persistence");
                assert (false);
            }
            case PersistenceNormal: {
                try {
                    this.normalHandler.add(event.getSerializedData(), ids);
                    break;
                }
                catch (IOException e) {
                    this.logger.error("AndroidCll-EventHandler", "Could not add event to normal storage");
                    return false;
                }
                catch (FileStorage.FileFullException e) {
                    this.logger.warn("AndroidCll-EventHandler", "No space on disk to store events");
                    return false;
                }
            }
            case PersistenceCritical: {
                try {
                    this.criticalHandler.add(event.getSerializedData(), ids);
                    break;
                }
                catch (IOException e) {
                    this.logger.error("AndroidCll-EventHandler", "Could not add event to normal storage");
                    return false;
                }
                catch (FileStorage.FileFullException e) {
                    this.logger.warn("AndroidCll-EventHandler", "No space on disk to store events");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean Filter(SerializedEvent event) {
        if (event.getSerializedData().length() > SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES)) {
            this.logger.info("AndroidCll-EventHandler", "Event is too large");
            return true;
        }
        if (!this.IsUploadEnabled() || !this.IsInSample(event)) {
            this.logger.info("AndroidCll-EventHandler", "Filtered event");
            return true;
        }
        return false;
    }

    private boolean IsInSample(SerializedEvent event) {
        if (this.sampleId < -1.0E-5) {
            this.sampleId = 0.0;
            String deviceId = event.getDeviceId();
            if (deviceId != null && deviceId.length() > 7) {
                try {
                    String lastDigits = deviceId.substring(deviceId.length() - 7);
                    this.sampleId = (double)(Long.parseLong(lastDigits, 16) % 10000L) / 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.logger.info("AndroidCll-EventHandler", "Sample Id is " + String.valueOf(this.sampleId) + " based on deviceId of " + deviceId);
        }
        return this.sampleId < event.getSampleRate() + 1.0E-5;
    }

    private boolean IsUploadEnabled() {
        return SettingsStore.getCllSettingsAsBoolean(SettingsStore.Settings.UPLOADENABLED);
    }

    protected boolean send() {
        return this.send(null);
    }

    protected boolean send(EventEnums.Persistence persistence) {
        if (this.isPaused) {
            return false;
        }
        List<IStorage> storages = null;
        if (persistence == null) {
            this.logger.info("AndroidCll-EventHandler", "Draining All events");
            storages = this.normalHandler.getFilesForDraining();
            storages.addAll(this.criticalHandler.getFilesForDraining());
        } else {
            switch (persistence) {
                case PersistenceNormal: {
                    this.logger.info("AndroidCll-EventHandler", "Draining normal events");
                    storages = this.normalHandler.getFilesForDraining();
                    break;
                }
                case PersistenceCritical: {
                    this.logger.info("AndroidCll-EventHandler", "Draining Critical events");
                    storages = this.criticalHandler.getFilesForDraining();
                    break;
                }
                default: {
                    this.logger.error("AndroidCll-EventHandler", "Unknown persistence");
                    assert (false);
                    break;
                }
            }
        }
        if (storages != null && storages.size() != 0) {
            return this.startEventQueueWriter(new EventQueueWriter(this.endpoint, storages, this.clientTelemetry, this.cllEvents, this.logger, this.executor, this.ticketCallback));
        }
        return true;
    }

    protected void setEndpointUrl(String endpointUrl) {
        try {
            this.endpoint = new URL(endpointUrl);
        }
        catch (MalformedURLException e) {
            this.logger.error("AndroidCll-EventHandler", "Bad Endpoint URL Form");
        }
    }

    void setSender(EventSender sender) {
        this.sender = sender;
    }

    void synchronize() {
        ((NormalEventHandler)this.normalHandler).writeQueueToDisk();
    }

    void setXuidCallback(ITicketCallback callback) {
        this.ticketCallback = callback;
    }

    private boolean startEventQueueWriter(Runnable r) {
        if (this.endpoint == null) {
            this.logger.warn("AndroidCll-EventHandler", "No endpoint set");
            return false;
        }
        EventQueueWriter eqw = (EventQueueWriter)r;
        if (this.sender != null) {
            eqw.setSender(this.sender);
        }
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            this.logger.warn("AndroidCll-EventHandler", "Could not start new thread for EventQueueWriter");
            return false;
        }
        catch (NullPointerException e) {
            this.logger.error("AndroidCll-EventHandler", "Executor is null. Is the cll paused or stopped?");
        }
        return true;
    }
}

