/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.usernotifications;

import android.support.annotation.IntRange;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.EventListener;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeObjectArrayAsyncOperation;
import com.microsoft.connecteddevices.base.NativeVoidEventListener;
import com.microsoft.connecteddevices.usernotifications.UserNotification;

@Keep
public class UserNotificationReader
extends NativeBase {
    protected UserNotificationReader(NativeObject nativeObject) {
        super(nativeObject);
    }

    @NonNull
    public AsyncOperation<UserNotification[]> readBatchAsync(@IntRange(from=0L) long maxBatchSize) {
        if (maxBatchSize < 0L) {
            throw new IllegalArgumentException("Maximum batch size must be non-negative");
        }
        NativeObjectArrayAsyncOperation<UserNotification> operation = new NativeObjectArrayAsyncOperation<UserNotification>(UserNotification.class);
        UserNotificationReader.readBatchAsyncNative(this.getNativePointer(), maxBatchSize, operation);
        return operation;
    }

    @NonNull
    public String getSerializedState() {
        return UserNotificationReader.getSerializedStateNative(this.getNativePointer());
    }

    public long addDataChangedListener(@NonNull EventListener<UserNotificationReader, Void> listener) {
        NativeVoidEventListener<UserNotificationReader> nativeListener = new NativeVoidEventListener<UserNotificationReader>(UserNotificationReader.class, listener);
        return UserNotificationReader.addDataChangedListenerNative(this.getNativePointer(), nativeListener);
    }

    public void removeDataChangedListener(long eventRegistrationToken) {
        UserNotificationReader.removeDataChangedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    private static native void readBatchAsyncNative(long var0, long var2, NativeObjectArrayAsyncOperation<UserNotification> var4);

    private static native String getSerializedStateNative(long var0);

    private static native long addDataChangedListenerNative(long var0, NativeVoidEventListener<UserNotificationReader> var2);

    private static native void removeDataChangedListenerNative(long var0, long var2);
}

