/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.usernotifications;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.userdata.UserDataFeed;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import com.microsoft.connecteddevices.usernotifications.UserNotification;
import com.microsoft.connecteddevices.usernotifications.UserNotificationChannelSyncScope;
import com.microsoft.connecteddevices.usernotifications.UserNotificationReader;
import com.microsoft.connecteddevices.usernotifications.UserNotificationReaderOptions;
import com.microsoft.connecteddevices.usernotifications.UserNotificationUpdateResult;

@Keep
public final class UserNotificationChannel
extends NativeBase {
    UserNotificationChannel(NativeObject nativeObject) {
        super(nativeObject);
    }

    public UserNotificationChannel(@NonNull UserDataFeed userDataFeed) {
        super(UserNotificationChannel.createInstanceNative(NativeUtils.getNativePointer(userDataFeed)));
    }

    @NonNull
    public UserNotificationReader createReader() {
        return NativeObject.toSpecific(UserNotificationChannel.createReaderNative(this.getNativePointer()), UserNotificationReader.class);
    }

    @NonNull
    public UserNotificationReader createReaderWithOptions(@NonNull UserNotificationReaderOptions options) {
        return NativeObject.toSpecific(UserNotificationChannel.createReaderWithOptionsNative(this.getNativePointer(), options.getNativePointer()), UserNotificationReader.class);
    }

    @NonNull
    public UserNotificationReader createReaderWithState(@NonNull String serializedState) {
        return NativeObject.toSpecific(UserNotificationChannel.createReaderWithStateNative(this.getNativePointer(), serializedState), UserNotificationReader.class);
    }

    @NonNull
    public AsyncOperation<UserNotification> getUserNotificationAsync(@NonNull String notificationId) {
        NativeObjectAsyncOperation<UserNotification> operation = new NativeObjectAsyncOperation<UserNotification>(UserNotification.class);
        UserNotificationChannel.getUserNotificationAsyncNative(this.getNativePointer(), notificationId, operation);
        return operation;
    }

    @NonNull
    public AsyncOperation<UserNotificationUpdateResult> deleteUserNotificationAsync(@NonNull String notificationId) {
        NativeObjectAsyncOperation<UserNotificationUpdateResult> operation = new NativeObjectAsyncOperation<UserNotificationUpdateResult>(UserNotificationUpdateResult.class);
        UserNotificationChannel.deleteUserNotificationAsyncNative(this.getNativePointer(), notificationId, operation);
        return operation;
    }

    @NonNull
    public static UserDataFeedSyncScope getSyncScope() {
        return NativeObject.toSpecific(UserNotificationChannel.getSyncScopeNative(), UserNotificationChannelSyncScope.class);
    }

    private static native NativeObject createInstanceNative(long var0);

    private static native NativeObject createReaderNative(long var0);

    private static native NativeObject createReaderWithOptionsNative(long var0, long var2);

    private static native NativeObject createReaderWithStateNative(long var0, String var2);

    private static native void getUserNotificationAsyncNative(long var0, String var2, NativeObjectAsyncOperation<UserNotification> var3);

    private static native void deleteUserNotificationAsyncNative(long var0, String var2, NativeObjectAsyncOperation<UserNotificationUpdateResult> var3);

    private static native NativeObject getSyncScopeNative();
}

