/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.userdata;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.EventListener;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.base.NativeVoidEventListener;
import com.microsoft.connecteddevices.core.Platform;
import com.microsoft.connecteddevices.core.UserAccount;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncStatus;

@Keep
public final class UserDataFeed
extends NativeBase {
    UserDataFeed(NativeObject obj) {
        super(obj);
    }

    @NonNull
    public static UserDataFeed getForAccount(@NonNull UserAccount userAccount, @NonNull Platform platform, @NonNull String activitySourceHost) {
        return NativeObject.toSpecific(UserDataFeed.getForAccountNative(NativeUtils.getNativePointer(userAccount), NativeUtils.getNativePointer(platform), activitySourceHost), UserDataFeed.class);
    }

    public void addSyncScopes(@NonNull UserDataFeedSyncScope[] syncScopes) {
        this.addSyncScopesNative(this.getNativePointer(), NativeUtils.convertToNativeArray(syncScopes));
    }

    public long addSyncStatusChangedListener(@NonNull EventListener<UserDataFeed, Void> listener) {
        return this.addSyncStatusChangedListenerNative(this.getNativePointer(), new NativeVoidEventListener<UserDataFeed>(UserDataFeed.class, listener));
    }

    public void removeSyncStatusChangedListener(long eventRegistrationToken) {
        this.removeSyncStatusChangedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    public void startSync() {
        this.startSyncNative(this.getNativePointer());
    }

    public UserDataFeedSyncStatus getSyncStatus() {
        return UserDataFeedSyncStatus.fromInt(this.getSyncStatusNative(this.getNativePointer()));
    }

    private native void addSyncScopesNative(long var1, long[] var3);

    private native int getSyncStatusNative(long var1);

    private native void startSyncNative(long var1);

    private native long addSyncStatusChangedListenerNative(long var1, NativeVoidEventListener<UserDataFeed> var3);

    private native void removeSyncStatusChangedListenerNative(long var1, long var3);

    private static native NativeObject getForAccountNative(long var0, long var2, String var4);
}

