/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.useractivities;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeObjectArrayAsyncOperation;
import com.microsoft.connecteddevices.base.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.useractivities.UserActivity;
import com.microsoft.connecteddevices.useractivities.UserActivityChannelSyncScope;
import com.microsoft.connecteddevices.useractivities.UserActivitySessionHistoryItem;
import com.microsoft.connecteddevices.userdata.UserDataFeed;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import java.util.Date;

@Keep
public final class UserActivityChannel
extends NativeBase {
    UserActivityChannel(NativeObject obj) {
        super(obj);
    }

    public UserActivityChannel(@NonNull UserDataFeed userDataFeed) {
        super(UserActivityChannel.createInstanceNative(NativeUtils.getNativePointer(userDataFeed)));
    }

    @NonNull
    public AsyncOperation<UserActivity> getOrCreateUserActivityAsync(@NonNull String activityId) {
        NativeObjectAsyncOperation<UserActivity> callback = new NativeObjectAsyncOperation<UserActivity>(UserActivity.class);
        this.getOrCreateUserActivityAsyncNative(this.getNativePointer(), activityId, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<Void> deleteActivityAsync(@NonNull String activityId) {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.deleteActivityAsyncNative(this.getNativePointer(), activityId, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<Void> deleteAllActivitiesAsync() {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.deleteAllActivitiesAsyncNative(this.getNativePointer(), callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<UserActivitySessionHistoryItem[]> getRecentUserActivitiesAsync(int maxUniqueActivities) {
        NativeObjectArrayAsyncOperation<UserActivitySessionHistoryItem> callback = new NativeObjectArrayAsyncOperation<UserActivitySessionHistoryItem>(UserActivitySessionHistoryItem.class);
        this.getRecentUserActivitiesAsyncNative(this.getNativePointer(), maxUniqueActivities, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<UserActivitySessionHistoryItem[]> getSessionHistoryItemsForUserActivityAsync(@NonNull String activityId, @NonNull Date startTime) {
        NativeObjectArrayAsyncOperation<UserActivitySessionHistoryItem> callback = new NativeObjectArrayAsyncOperation<UserActivitySessionHistoryItem>(UserActivitySessionHistoryItem.class);
        this.getSessionHistoryItemsForUserActivityAsyncNative(this.getNativePointer(), activityId, startTime, callback);
        return callback;
    }

    @NonNull
    public static UserDataFeedSyncScope getSyncScope() {
        return NativeObject.toSpecific(UserActivityChannel.getSyncScopeNative(), UserActivityChannelSyncScope.class);
    }

    private static native NativeObject createInstanceNative(long var0);

    private native void getOrCreateUserActivityAsyncNative(long var1, String var3, AsyncOperation<UserActivity> var4);

    private native void deleteActivityAsyncNative(long var1, String var3, AsyncOperation<Void> var4);

    private native void deleteAllActivitiesAsyncNative(long var1, AsyncOperation<Void> var3);

    private native void getRecentUserActivitiesAsyncNative(long var1, int var3, AsyncOperation<UserActivitySessionHistoryItem[]> var4);

    private native void getSessionHistoryItemsForUserActivityAsyncNative(long var1, String var3, Date var4, AsyncOperation<UserActivitySessionHistoryItem[]> var5);

    private static native NativeObject getSyncScopeNative();
}

