/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.useractivities;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.useractivities.UserActivitySession;
import com.microsoft.connecteddevices.useractivities.UserActivityState;
import com.microsoft.connecteddevices.useractivities.UserActivityVisualElements;

@Keep
public final class UserActivity
extends NativeBase {
    UserActivity(NativeObject obj) {
        super(obj);
    }

    public UserActivity(@NonNull String activityId) {
        super(UserActivity.createInstanceNative(activityId));
    }

    @NonNull
    public String getActivityId() {
        return this.getActivityIdNative(this.getNativePointer());
    }

    @NonNull
    public UserActivityState getState() {
        return UserActivityState.fromInt(this.getStateNative(this.getNativePointer()));
    }

    public void setContentUri(@Nullable String contentUri) {
        this.setContentUriNative(this.getNativePointer(), contentUri);
    }

    @Nullable
    public String getContentUri() {
        return this.getContentUriNative(this.getNativePointer());
    }

    public void setFallbackUri(@Nullable String fallbackUri) {
        this.setFallbackUriNative(this.getNativePointer(), fallbackUri);
    }

    @Nullable
    public String getFallbackUri() {
        return this.getFallbackUriNative(this.getNativePointer());
    }

    public void setContentType(@Nullable String contentType) {
        this.setContentTypeNative(this.getNativePointer(), contentType);
    }

    @Nullable
    public String getContentType() {
        return this.getContentTypeNative(this.getNativePointer());
    }

    public void setActivationUri(@NonNull String activationUri) {
        this.setActivationUriNative(this.getNativePointer(), activationUri);
    }

    @NonNull
    public String getActivationUri() {
        return this.getActivationUriNative(this.getNativePointer());
    }

    public void setContentInfoJson(@Nullable String contentInfoJson) {
        this.setContentInfoJsonNative(this.getNativePointer(), contentInfoJson);
    }

    @Nullable
    public String getContentInfoJson() {
        return this.getContentInfoJsonNative(this.getNativePointer());
    }

    public void setVisualElements(@NonNull UserActivityVisualElements visualElements) {
        this.setVisualElementsNative(this.getNativePointer(), NativeUtils.getNativePointer(visualElements));
    }

    @NonNull
    public UserActivityVisualElements getVisualElements() {
        return NativeObject.toSpecific(this.getVisualElementsNative(this.getNativePointer()), UserActivityVisualElements.class);
    }

    public void setIsRoamable(boolean roamable) {
        this.setIsRoamableNative(this.getNativePointer(), roamable);
    }

    public boolean getIsRoamable() {
        return this.getIsRoamableNative(this.getNativePointer());
    }

    @NonNull
    public AsyncOperation<Void> saveAsync() {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.saveAsyncNative(this.getNativePointer(), callback);
        return callback;
    }

    @NonNull
    public UserActivitySession createSession() {
        return NativeObject.toSpecific(this.createSessionNative(this.getNativePointer()), UserActivitySession.class);
    }

    private static native NativeObject createInstanceNative(String var0);

    private native String getActivityIdNative(long var1);

    private native int getStateNative(long var1);

    private native void setContentUriNative(long var1, String var3);

    private native String getContentUriNative(long var1);

    private native void setFallbackUriNative(long var1, String var3);

    private native String getFallbackUriNative(long var1);

    private native void setContentTypeNative(long var1, String var3);

    private native String getContentTypeNative(long var1);

    private native void setActivationUriNative(long var1, String var3);

    private native String getActivationUriNative(long var1);

    private native void setContentInfoJsonNative(long var1, String var3);

    private native String getContentInfoJsonNative(long var1);

    private native void setVisualElementsNative(long var1, long var3);

    private native NativeObject getVisualElementsNative(long var1);

    private native void saveAsyncNative(long var1, AsyncOperation<Void> var3);

    private native NativeObject createSessionNative(long var1);

    private native boolean getIsRoamableNative(long var1);

    private native void setIsRoamableNative(long var1, boolean var3);
}

