/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.nearshare;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.CancellationToken;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeEnumAsyncOperation;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.commanding.RemoteSystemConnectionRequest;
import com.microsoft.connecteddevices.nearshare.NearShareFileProvider;
import com.microsoft.connecteddevices.nearshare.NearShareStatus;
import com.microsoft.connecteddevices.nearshare.ProgressCallback;

@Keep
public final class NearShareSender
extends NativeBase {
    NearShareSender(NativeObject nativeObject) {
        super(nativeObject);
    }

    public NearShareSender() {
        super(NearShareSender.createInstanceNative());
    }

    @NonNull
    public AsyncOperation<NearShareStatus> sendUriAsync(RemoteSystemConnectionRequest remoteSystemConnectionRequest, String uri) {
        NativeEnumAsyncOperation<NearShareStatus> operation = new NativeEnumAsyncOperation<NearShareStatus>(NearShareStatus.class);
        this.sendUriAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(remoteSystemConnectionRequest), uri, operation);
        return operation;
    }

    @NonNull
    public AsyncOperation<NearShareStatus> sendFilesAsync(RemoteSystemConnectionRequest remoteSystemConnectionRequest, NearShareFileProvider[] files, ProgressCallback progressCallback) {
        NativeEnumAsyncOperation<NearShareStatus> operation = new NativeEnumAsyncOperation<NearShareStatus>(NearShareStatus.class);
        CancellationToken cancellationToken = new CancellationToken(this.sendFilesAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(remoteSystemConnectionRequest), files, operation, progressCallback));
        operation.setCancellationToken(cancellationToken);
        return operation;
    }

    @NonNull
    public AsyncOperation<NearShareStatus> sendFileAsync(RemoteSystemConnectionRequest remoteSystemConnectionRequest, NearShareFileProvider file, ProgressCallback progressCallback) {
        NativeEnumAsyncOperation<NearShareStatus> operation = new NativeEnumAsyncOperation<NearShareStatus>(NearShareStatus.class);
        CancellationToken cancellationToken = new CancellationToken(this.sendFileAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(remoteSystemConnectionRequest), file, operation, progressCallback));
        operation.setCancellationToken(cancellationToken);
        return operation;
    }

    public boolean isNearShareSupported(RemoteSystemConnectionRequest remoteSystemConnectionRequest) {
        return NearShareSender.isNearShareSupportedNative(remoteSystemConnectionRequest.getNativePointer());
    }

    private static native NativeObject createInstanceNative();

    private static native boolean isNearShareSupportedNative(long var0);

    private native void sendUriAsyncNative(long var1, long var3, String var5, AsyncOperation<NearShareStatus> var6);

    private native NativeObject sendFilesAsyncNative(long var1, long var3, NearShareFileProvider[] var5, AsyncOperation<NearShareStatus> var6, ProgressCallback var7);

    private native NativeObject sendFileAsyncNative(long var1, long var3, NearShareFileProvider var5, AsyncOperation<NearShareStatus> var6, ProgressCallback var7);
}

