/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.discovery;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.EventListener;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeEnumEventListener;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeObjectEventListener;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.base.NativeVoidEventListener;
import com.microsoft.connecteddevices.discovery.RemoteSystem;
import com.microsoft.connecteddevices.discovery.RemoteSystemFilter;
import com.microsoft.connecteddevices.discovery.RemoteSystemWatcherError;

@Keep
public final class RemoteSystemWatcher
extends NativeBase {
    public RemoteSystemWatcher() {
        super(RemoteSystemWatcher.createInstanceNative());
    }

    public RemoteSystemWatcher(@NonNull RemoteSystemFilter[] filters) {
        super(RemoteSystemWatcher.createInstanceNative(NativeUtils.convertToNativeArray(filters)));
    }

    RemoteSystemWatcher(NativeObject nativeObject) {
        super(nativeObject);
    }

    public void start() {
        this.startNative(this.getNativePointer());
    }

    public void stop() {
        this.stopNative(this.getNativePointer());
    }

    public long addRemoteSystemAddedListener(@NonNull EventListener<RemoteSystemWatcher, RemoteSystem> listener) {
        return this.addRemoteSystemAddedListenerNative(this.getNativePointer(), new NativeObjectEventListener<RemoteSystemWatcher, RemoteSystem>(RemoteSystemWatcher.class, RemoteSystem.class, listener));
    }

    public void removeRemoteSystemAddedListener(long eventRegistrationToken) {
        this.removeRemoteSystemAddedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    public long addRemoteSystemUpdatedListener(@NonNull EventListener<RemoteSystemWatcher, RemoteSystem> listener) {
        return this.addRemoteSystemUpdatedListenerNative(this.getNativePointer(), new NativeObjectEventListener<RemoteSystemWatcher, RemoteSystem>(RemoteSystemWatcher.class, RemoteSystem.class, listener));
    }

    public void removeRemoteSystemUpdatedListener(long eventRegistrationToken) {
        this.removeRemoteSystemUpdatedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    public long addRemoteSystemRemovedListener(@NonNull EventListener<RemoteSystemWatcher, RemoteSystem> listener) {
        return this.addRemoteSystemRemovedListenerNative(this.getNativePointer(), new NativeObjectEventListener<RemoteSystemWatcher, RemoteSystem>(RemoteSystemWatcher.class, RemoteSystem.class, listener));
    }

    public void removeRemoteSystemRemovedListener(long eventRegistrationToken) {
        this.removeRemoteSystemRemovedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    public long addEnumerationCompletedListener(@NonNull EventListener<RemoteSystemWatcher, Void> listener) {
        return this.addEnumerationCompletedListenerNative(this.getNativePointer(), new NativeVoidEventListener<RemoteSystemWatcher>(RemoteSystemWatcher.class, listener));
    }

    public void removeEnumerationCompletedListener(long eventRegistrationToken) {
        this.removeEnumerationCompletedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    public long addErrorOccurredListener(@NonNull EventListener<RemoteSystemWatcher, RemoteSystemWatcherError> listener) {
        return this.addErrorOccurredListenerNative(this.getNativePointer(), new NativeEnumEventListener<RemoteSystemWatcher, RemoteSystemWatcherError>(RemoteSystemWatcher.class, RemoteSystemWatcherError.class, listener));
    }

    public void removeErrorOccurredListener(long eventRegistrationToken) {
        this.removeErrorOccurredListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    private static native NativeObject createInstanceNative();

    private static native NativeObject createInstanceNative(long[] var0);

    private native void startNative(long var1);

    private native void stopNative(long var1);

    private native long addRemoteSystemAddedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystem> var3);

    private native void removeRemoteSystemAddedListenerNative(long var1, long var3);

    private native long addRemoteSystemUpdatedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystem> var3);

    private native void removeRemoteSystemUpdatedListenerNative(long var1, long var3);

    private native long addRemoteSystemRemovedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystem> var3);

    private native void removeRemoteSystemRemovedListenerNative(long var1, long var3);

    private native long addEnumerationCompletedListenerNative(long var1, NativeVoidEventListener<RemoteSystemWatcher> var3);

    private native void removeEnumerationCompletedListenerNative(long var1, long var3);

    private native long addErrorOccurredListenerNative(long var1, NativeEnumEventListener<RemoteSystemWatcher, RemoteSystemWatcherError> var3);

    private native void removeErrorOccurredListenerNative(long var1, long var3);
}

