/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.commanding;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.EventListener;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeEnumAsyncOperation;
import com.microsoft.connecteddevices.base.NativeEnumEventListener;
import com.microsoft.connecteddevices.base.NativeObject;
import com.microsoft.connecteddevices.base.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.base.NativeObjectEventListener;
import com.microsoft.connecteddevices.base.NativeUtils;
import com.microsoft.connecteddevices.commanding.AppServiceClosedStatus;
import com.microsoft.connecteddevices.commanding.AppServiceConnectionStatus;
import com.microsoft.connecteddevices.commanding.AppServiceRequestReceivedEventArgs;
import com.microsoft.connecteddevices.commanding.AppServiceResponse;
import com.microsoft.connecteddevices.commanding.RemoteSystemConnectionRequest;
import com.microsoft.connecteddevices.discovery.AppServiceDescription;
import java.util.Map;

@Keep
public final class AppServiceConnection
extends NativeBase {
    AppServiceConnection(NativeObject nativeObject) {
        super(nativeObject);
    }

    public AppServiceConnection() {
        super(AppServiceConnection.createInstanceNative());
    }

    public AppServiceConnection(@NonNull AppServiceDescription appServiceDescription) {
        super(AppServiceConnection.createInstanceNative(appServiceDescription.getNativePointer()));
    }

    public void close() {
        this.closeNative(this.getNativePointer());
    }

    @NonNull
    public AsyncOperation<AppServiceConnectionStatus> openRemoteAsync(@NonNull RemoteSystemConnectionRequest connection) {
        NativeEnumAsyncOperation<AppServiceConnectionStatus> operation = new NativeEnumAsyncOperation<AppServiceConnectionStatus>(AppServiceConnectionStatus.class);
        this.openRemoteAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(connection), operation);
        return operation;
    }

    @NonNull
    public AsyncOperation<AppServiceResponse> sendMessageAsync(@NonNull Map<String, Object> messageMap) {
        NativeObjectAsyncOperation<AppServiceResponse> operation = new NativeObjectAsyncOperation<AppServiceResponse>(AppServiceResponse.class);
        this.sendMessageAsyncNative(this.getNativePointer(), messageMap, operation);
        return operation;
    }

    @NonNull
    public AppServiceDescription getAppServiceDescription() {
        return NativeObject.toSpecific(this.getAppServiceDescriptionNative(this.getNativePointer()), AppServiceDescription.class);
    }

    public void setAppServiceDescription(@NonNull AppServiceDescription appServiceDescription) {
        this.setAppServiceDescriptionNative(this.getNativePointer(), appServiceDescription.getNativePointer());
    }

    public long addRequestReceivedListener(@NonNull EventListener<AppServiceConnection, AppServiceRequestReceivedEventArgs> listener) {
        return this.addRequestReceivedListenerNative(this.getNativePointer(), new NativeObjectEventListener<AppServiceConnection, AppServiceRequestReceivedEventArgs>(AppServiceConnection.class, AppServiceRequestReceivedEventArgs.class, listener));
    }

    public void removeRequestReceivedListener(long eventRegistrationToken) {
        this.removeRequestReceivedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    public long addServiceClosedListener(@NonNull EventListener<AppServiceConnection, AppServiceClosedStatus> listener) {
        return this.addServiceClosedListenerNative(this.getNativePointer(), new NativeEnumEventListener<AppServiceConnection, AppServiceClosedStatus>(AppServiceConnection.class, AppServiceClosedStatus.class, listener));
    }

    public void removeServiceClosedListener(long eventRegistrationToken) {
        this.removeServiceClosedListenerNative(this.getNativePointer(), eventRegistrationToken);
    }

    private static native NativeObject createInstanceNative();

    private static native NativeObject createInstanceNative(long var0);

    private native void closeNative(long var1);

    private native void openRemoteAsyncNative(long var1, long var3, AsyncOperation<AppServiceConnectionStatus> var5);

    private native void sendMessageAsyncNative(long var1, Map var3, AsyncOperation<AppServiceResponse> var4);

    private native NativeObject getAppServiceDescriptionNative(long var1);

    private native void setAppServiceDescriptionNative(long var1, long var3);

    private native long addRequestReceivedListenerNative(long var1, NativeObjectEventListener<AppServiceConnection, AppServiceRequestReceivedEventArgs> var3);

    private native void removeRequestReceivedListenerNative(long var1, long var3);

    private native long addServiceClosedListenerNative(long var1, NativeEnumEventListener<AppServiceConnection, AppServiceClosedStatus> var3);

    private native void removeServiceClosedListenerNative(long var1, long var3);
}

