/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.base;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.base.ErrorCode;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.SdkException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeUtils {
    private NativeUtils() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> long[] convertToNativeArray(T[] bases) {
        if (bases == null) {
            return null;
        }
        long[] toReturn = new long[bases.length];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = NativeUtils.getNativePointerFromInterface(bases[i]);
        }
        return toReturn;
    }

    static <T extends Enum> T getEnumFromInt(int value, Class<T> enumClass) {
        try {
            Method method = enumClass.getDeclaredMethod("fromInt", Integer.TYPE);
            method.setAccessible(true);
            return (T)((Enum)method.invoke(null, value));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SdkException(ErrorCode.UNKNOWN, "Failed to construct enum class " + enumClass.toString() + ", message: " + e.getMessage());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void registerContext(Context context) {
        NativeUtils.registerContextNative(context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static long getNativePointer(NativeBase projectedObject) {
        return projectedObject == null ? 0L : projectedObject.getNativePointer();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> long getNativePointerFromInterface(T interfaceObject) {
        return interfaceObject instanceof NativeBase ? NativeUtils.getNativePointer((NativeBase)interfaceObject) : 0L;
    }

    private static native void registerContextNative(Context var0);
}

