/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.base;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.base.EventListener;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import java.lang.reflect.InvocationTargetException;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeStringEventListener<TSourceObject extends NativeBase> {
    private final EventListener<TSourceObject, String> mListener;
    private final Class<TSourceObject> mSourceClass;

    public NativeStringEventListener(Class<TSourceObject> sourceClass, @NonNull EventListener<TSourceObject, String> listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.mListener = listener;
        this.mSourceClass = sourceClass;
    }

    @Keep
    void onEvent(NativeObject nativeEventSource, String eventArg) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        TSourceObject eventSource = NativeObject.toSpecific(nativeEventSource, this.mSourceClass);
        this.mListener.onEvent(eventSource, eventArg);
    }
}

