/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.base;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.base.EventListener;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativeObject;
import java.lang.reflect.InvocationTargetException;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeObjectEventListener<TSourceObject extends NativeBase, TArgObject extends NativeBase> {
    private final EventListener<TSourceObject, TArgObject> mListener;
    private final Class<TSourceObject> mSourceClass;
    private final Class<TArgObject> mArgClass;

    public NativeObjectEventListener(Class<TSourceObject> sourceClass, Class<TArgObject> argClass, @NonNull EventListener<TSourceObject, TArgObject> listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.mListener = listener;
        this.mSourceClass = sourceClass;
        this.mArgClass = argClass;
    }

    @Keep
    void onEvent(NativeObject nativeEventSource, NativeObject nativeEventArg) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        TSourceObject eventSource = NativeObject.toSpecific(nativeEventSource, this.mSourceClass);
        TArgObject eventArg = NativeObject.toSpecific(nativeEventArg, this.mArgClass);
        this.mListener.onEvent(eventSource, eventArg);
    }
}

