/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.base;

import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.base.ErrorCode;
import com.microsoft.connecteddevices.base.NativeBase;
import com.microsoft.connecteddevices.base.NativePointerHolder;
import com.microsoft.connecteddevices.base.SDKLoader;
import com.microsoft.connecteddevices.base.SdkException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeObject
extends SDKLoader
implements NativePointerHolder,
AutoCloseable {
    private long mRawPointer;

    NativeObject(long rawPointer) {
        if (rawPointer != 0L) {
            this.addRef(rawPointer);
            this.mRawPointer = rawPointer;
        }
    }

    public static <T extends NativeBase> T toSpecific(NativeObject nativeObject, Class<T> desiredClass) {
        if (nativeObject == null || nativeObject.getNativePointer() == 0L) {
            return null;
        }
        try {
            Constructor<T> constructor = desiredClass.getDeclaredConstructor(NativeObject.class);
            constructor.setAccessible(true);
            return (T)((NativeBase)constructor.newInstance(nativeObject));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SdkException(ErrorCode.UNKNOWN, "Failed to construct desired class " + desiredClass.toString() + ", message: " + e.getMessage());
        }
    }

    public static <T extends NativeBase> T[] toSpecificArray(NativeObject[] nativeObjects, Class<T> desiredClass) {
        if (nativeObjects == null) {
            return null;
        }
        NativeBase[] toReturn = (NativeBase[])Array.newInstance(desiredClass, nativeObjects.length);
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = NativeObject.toSpecific(nativeObjects[i], desiredClass);
        }
        return toReturn;
    }

    public int hashCode() {
        return Objects.hash(this.mRawPointer);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NativeObject)) {
            return false;
        }
        return ((NativeObject)object).mRawPointer == this.mRawPointer;
    }

    @Override
    public void close() throws Exception {
        long tempRawPointer = this.mRawPointer;
        if (tempRawPointer != 0L) {
            this.mRawPointer = 0L;
            this.release(tempRawPointer);
        }
    }

    @Override
    public long getNativePointer() {
        return this.mRawPointer;
    }

    public boolean isNull() {
        return this.mRawPointer == 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private native void addRef(long var1);

    private native void release(long var1);
}

