/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.base;

import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.base.AsyncOperation;
import com.microsoft.connecteddevices.base.CancellationToken;
import com.microsoft.connecteddevices.base.NativeUtils;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NativeEnumAsyncOperation<T extends Enum<T>>
extends AsyncOperation<T> {
    private Class<T> mEnumClass;
    private CancellationToken mCancellationToken;

    private NativeEnumAsyncOperation() {
    }

    public NativeEnumAsyncOperation(Class<T> enumClass) {
        this.mEnumClass = enumClass;
    }

    @Override
    final void complete(int value) {
        super.complete(NativeUtils.getEnumFromInt(value, this.mEnumClass));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        if (null != this.mCancellationToken) {
            this.mCancellationToken.cancel();
        }
        return result;
    }

    public void setCancellationToken(CancellationToken cancellationToken) {
        this.mCancellationToken = cancellationToken;
    }
}

