/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.base;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.base.DirectExecutor;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Keep
public class AsyncOperation<T>
implements Future<T> {
    private static final DirectExecutor sDirectExecutor = new DirectExecutor();
    private static final ExecutorService sDefaultExecutor = Executors.newCachedThreadPool();
    private T mResult;
    private boolean mIsDone;
    private boolean mIsCancelled;
    private Throwable mException;
    private ArrayList<Pair<Runnable, Executor>> mDependentOperations = new ArrayList();

    @Override
    public boolean isDone() {
        return this.mIsDone;
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        ArrayList<Pair<Runnable, Executor>> operationsToInvoke = null;
        boolean shouldInvoke = false;
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                shouldInvoke = true;
                this.mIsCancelled = true;
                this.mIsDone = true;
                operationsToInvoke = this.mDependentOperations;
                this.mDependentOperations = new ArrayList();
                this.notifyAll();
            }
        }
        if (shouldInvoke) {
            this._invokeDependentOperations(operationsToInvoke);
        }
        return this.mIsCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException, CancellationException {
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                this.wait();
            }
        }
        this._checkExecutionException();
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException, CancellationException {
        long startTime = System.currentTimeMillis();
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            long currentTime;
            for (long timeToWait = unit.toMillis(timeout); !this.mIsDone && timeToWait > 0L; timeToWait -= currentTime - startTime) {
                this.wait(timeToWait);
                currentTime = System.currentTimeMillis();
                startTime = currentTime;
            }
        }
        if (!this.mIsDone) {
            throw new TimeoutException();
        }
        this._checkExecutionException();
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T join() throws InterruptedException, CompletionException, CancellationException {
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                this.wait();
            }
        }
        this._checkCompletionException();
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getNow(T valueIfAbsent) throws CompletionException, CancellationException {
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (this.mIsDone) {
                this._checkCompletionException();
                return this.mResult;
            }
        }
        return valueIfAbsent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompletedExceptionally() {
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            return this.mIsDone && (this.mIsCancelled || this.mException != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfDependents() {
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            return this.mDependentOperations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void complete(T value) {
        ArrayList<Pair<Runnable, Executor>> operationsToInvoke = null;
        boolean shouldInvoke = false;
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                this.mResult = value;
                this.mIsDone = true;
                shouldInvoke = true;
                operationsToInvoke = this.mDependentOperations;
                this.mDependentOperations = new ArrayList();
                this.notifyAll();
            }
        }
        if (shouldInvoke) {
            this._invokeDependentOperations(operationsToInvoke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void completeExceptionally(@NonNull Throwable ex) {
        if (ex == null) {
            throw new IllegalArgumentException("Exception cannot be null.");
        }
        ArrayList<Pair<Runnable, Executor>> operationsToInvoke = null;
        boolean shouldInvoke = false;
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                this.mException = ex;
                this.mIsDone = true;
                shouldInvoke = true;
                operationsToInvoke = this.mDependentOperations;
                this.mDependentOperations = new ArrayList();
                this.notifyAll();
            }
        }
        if (shouldInvoke) {
            this._invokeDependentOperations(operationsToInvoke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> AsyncOperation<U> _handleAsyncInternal(ResultBiFunction<? super T, ? super Throwable, ? extends U> action, Executor executor) {
        boolean shouldInvoke;
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null.");
        }
        final AsyncOperation<T> operationToReturn = new AsyncOperation<T>();
        final ResultBiFunction<? super T, ? super Throwable, ? extends U> runnableAction = action;
        ArrayList<Pair<Runnable, Executor>> operationsToInvoke = null;
        Pair<1, Executor> pairToAdd = new Pair<1, Executor>(new Runnable(){

            @Override
            public void run() {
                Object actionResult = null;
                Throwable actionException = null;
                try {
                    Object result = AsyncOperation.this.get();
                    try {
                        actionResult = runnableAction.apply(result, null);
                    }
                    catch (Throwable e) {
                        actionException = e;
                    }
                }
                catch (Throwable t) {
                    try {
                        actionResult = runnableAction.apply(null, t);
                    }
                    catch (Throwable e) {
                        actionException = e;
                    }
                }
                if (actionException == null) {
                    operationToReturn.complete(actionResult);
                } else {
                    operationToReturn.completeExceptionally(actionException);
                }
            }
        }, executor);
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                this.mDependentOperations.add(pairToAdd);
            } else {
                operationsToInvoke = new ArrayList<Pair<Runnable, Executor>>();
                operationsToInvoke.add(pairToAdd);
            }
            shouldInvoke = this.mIsDone;
        }
        if (shouldInvoke) {
            this._invokeDependentOperations(operationsToInvoke);
        }
        return operationToReturn;
    }

    public <U> AsyncOperation<U> handleAsync(@NonNull ResultBiFunction<? super T, ? super Throwable, ? extends U> action, @NonNull Executor executor) {
        return this._handleAsyncInternal(action, executor);
    }

    public <U> AsyncOperation<U> handleAsync(@NonNull ResultBiFunction<? super T, ? super Throwable, ? extends U> action) {
        return this._handleAsyncInternal(action, sDefaultExecutor);
    }

    public <U> AsyncOperation<U> handle(@NonNull ResultBiFunction<? super T, ? super Throwable, ? extends U> action) {
        return this._handleAsyncInternal(action, sDirectExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncOperation<T> _whenCompleteAsyncInternal(ResultBiConsumer<? super T, ? super Throwable> action, Executor executor) {
        boolean shouldInvoke;
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null.");
        }
        final AsyncOperation<T> operationToReturn = new AsyncOperation<T>();
        final ResultBiConsumer<? super T, ? super Throwable> runnableAction = action;
        ArrayList<Pair<Runnable, Executor>> operationsToInvoke = null;
        Pair<2, Executor> pairToAdd = new Pair<2, Executor>(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = AsyncOperation.this.get();
                    try {
                        runnableAction.accept(result, null);
                        operationToReturn.complete(result);
                    }
                    catch (Throwable t) {
                        operationToReturn.completeExceptionally(t);
                    }
                }
                catch (Throwable t) {
                    try {
                        runnableAction.accept(null, t);
                        operationToReturn.completeExceptionally(t);
                    }
                    catch (Throwable e) {
                        operationToReturn.completeExceptionally(t);
                    }
                }
            }
        }, executor);
        AsyncOperation asyncOperation = this;
        synchronized (asyncOperation) {
            if (!this.mIsDone) {
                this.mDependentOperations.add(pairToAdd);
            } else {
                operationsToInvoke = new ArrayList<Pair<Runnable, Executor>>();
                operationsToInvoke.add(pairToAdd);
            }
            shouldInvoke = this.mIsDone;
        }
        if (shouldInvoke) {
            this._invokeDependentOperations(operationsToInvoke);
        }
        return operationToReturn;
    }

    public AsyncOperation<T> whenCompleteAsync(@NonNull ResultBiConsumer<? super T, ? super Throwable> action, @NonNull Executor executor) {
        return this._whenCompleteAsyncInternal(action, executor);
    }

    public AsyncOperation<T> whenCompleteAsync(@NonNull ResultBiConsumer<? super T, ? super Throwable> action) {
        return this._whenCompleteAsyncInternal(action, sDefaultExecutor);
    }

    public AsyncOperation<T> whenComplete(@NonNull ResultBiConsumer<? super T, ? super Throwable> action) {
        return this._whenCompleteAsyncInternal(action, sDirectExecutor);
    }

    public AsyncOperation<T> exceptionally(@NonNull ResultFunction<Throwable, ? extends T> action) {
        final ResultFunction<Throwable, ? extends T> runnableAction = action;
        return this._handleAsyncInternal(new ResultBiFunction<T, Throwable, T>(){

            @Override
            public T apply(T t, Throwable throwable) throws Throwable {
                if (throwable == null) {
                    return t;
                }
                return runnableAction.apply(throwable);
            }
        }, sDirectExecutor);
    }

    private AsyncOperation<Void> _thenRunAsyncInternal(Runnable action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        final Runnable runnableAction = action;
        return this._handleAsyncInternal(new ResultBiFunction<T, Throwable, Void>(){

            @Override
            public Void apply(T antecedentResult, Throwable antecedentException) throws Throwable {
                if (antecedentException != null) {
                    throw antecedentException;
                }
                runnableAction.run();
                return null;
            }
        }, executor);
    }

    public AsyncOperation<Void> thenRunAsync(@NonNull Runnable action, @NonNull Executor executor) {
        return this._thenRunAsyncInternal(action, executor);
    }

    public AsyncOperation<Void> thenRunAsync(@NonNull Runnable action) {
        return this._thenRunAsyncInternal(action, sDefaultExecutor);
    }

    public AsyncOperation<Void> thenRun(@NonNull Runnable action) {
        return this._thenRunAsyncInternal(action, sDirectExecutor);
    }

    private AsyncOperation<Void> _thenAcceptAsyncInternal(ResultConsumer<? super T> action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        final ResultConsumer<? super T> runnableAction = action;
        return this._handleAsyncInternal(new ResultBiFunction<T, Throwable, Void>(){

            @Override
            public Void apply(T antecedentResult, Throwable antecedentException) throws Throwable {
                if (antecedentException != null) {
                    throw antecedentException;
                }
                runnableAction.accept(antecedentResult);
                return null;
            }
        }, executor);
    }

    public AsyncOperation<Void> thenAcceptAsync(@NonNull ResultConsumer<? super T> action, @NonNull Executor executor) {
        return this._thenAcceptAsyncInternal(action, executor);
    }

    public AsyncOperation<Void> thenAcceptAsync(@NonNull ResultConsumer<? super T> action) {
        return this._thenAcceptAsyncInternal(action, sDefaultExecutor);
    }

    public AsyncOperation<Void> thenAccept(@NonNull ResultConsumer<? super T> action) {
        return this._thenAcceptAsyncInternal(action, sDirectExecutor);
    }

    private <U> AsyncOperation<U> _thenApplyAsyncInternal(ResultFunction<? super T, ? extends U> action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        final ResultFunction<? super T, ? extends U> runnableAction = action;
        return this._handleAsyncInternal(new ResultBiFunction<T, Throwable, U>(){

            @Override
            public U apply(T antecedentResult, Throwable antecedentException) throws Throwable {
                if (antecedentException != null) {
                    throw antecedentException;
                }
                return runnableAction.apply(antecedentResult);
            }
        }, executor);
    }

    public <U> AsyncOperation<U> thenApplyAsync(@NonNull ResultFunction<? super T, ? extends U> action, @NonNull Executor executor) {
        return this._thenApplyAsyncInternal(action, executor);
    }

    public <U> AsyncOperation<U> thenApplyAsync(@NonNull ResultFunction<? super T, ? extends U> action) {
        return this._thenApplyAsyncInternal(action, sDefaultExecutor);
    }

    public <U> AsyncOperation<U> thenApply(@NonNull ResultFunction<? super T, ? extends U> action) {
        return this._thenApplyAsyncInternal(action, sDirectExecutor);
    }

    private AsyncOperation<Void> _acceptEitherAsyncInternal(AsyncOperation<? extends T> other, ResultConsumer<? super T> action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        return super._thenAcceptAsyncInternal(action, executor);
    }

    public AsyncOperation<Void> acceptEitherAsync(@NonNull AsyncOperation<? extends T> other, ResultConsumer<? super T> action, @NonNull Executor executor) {
        return this._acceptEitherAsyncInternal(other, action, executor);
    }

    public AsyncOperation<Void> acceptEitherAsync(@NonNull AsyncOperation<? extends T> other, @NonNull ResultConsumer<? super T> action) {
        return this._acceptEitherAsyncInternal(other, action, sDefaultExecutor);
    }

    public AsyncOperation<Void> acceptEither(@NonNull AsyncOperation<? extends T> other, @NonNull ResultConsumer<? super T> action) {
        return this._acceptEitherAsyncInternal(other, action, sDirectExecutor);
    }

    private <U> AsyncOperation<U> _applyToEitherAsyncInternal(AsyncOperation<? extends T> other, ResultFunction<? super T, U> action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        return super._thenApplyAsyncInternal(action, executor);
    }

    public <U> AsyncOperation<U> applyToEitherAsync(@NonNull AsyncOperation<? extends T> other, @NonNull ResultFunction<? super T, U> action, @NonNull Executor executor) {
        return this._applyToEitherAsyncInternal(other, action, executor);
    }

    public <U> AsyncOperation<U> applyToEitherAsync(@NonNull AsyncOperation<? extends T> other, @NonNull ResultFunction<? super T, U> action) {
        return this._applyToEitherAsyncInternal(other, action, sDefaultExecutor);
    }

    public <U> AsyncOperation<U> applyToEither(@NonNull AsyncOperation<? extends T> other, @NonNull ResultFunction<? super T, U> action) {
        return this._applyToEitherAsyncInternal(other, action, sDirectExecutor);
    }

    private AsyncOperation<Void> _runAfterEitherAsyncInternal(AsyncOperation<?> other, Runnable action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null.");
        }
        final AsyncOperation<T> joinOperation = new AsyncOperation<T>();
        super._thenRunAsyncInternal(new Runnable(){

            @Override
            public void run() {
                joinOperation.complete(null);
            }
        }, sDirectExecutor);
        this._thenRunAsyncInternal(new Runnable(){

            @Override
            public void run() {
                joinOperation.complete(null);
            }
        }, sDirectExecutor);
        return super._thenRunAsyncInternal(action, executor);
    }

    public AsyncOperation<Void> runAfterEitherAsync(@NonNull AsyncOperation<?> other, @NonNull Runnable action, @NonNull Executor executor) {
        return this._runAfterEitherAsyncInternal(other, action, executor);
    }

    public AsyncOperation<Void> runAfterEitherAsync(@NonNull AsyncOperation<?> other, @NonNull Runnable action) {
        return this._runAfterEitherAsyncInternal(other, action, sDefaultExecutor);
    }

    public AsyncOperation<Void> runAfterEither(@NonNull AsyncOperation<?> other, @NonNull Runnable action) {
        return this._runAfterEitherAsyncInternal(other, action, sDirectExecutor);
    }

    private <U, V> AsyncOperation<V> _thenCombineAsyncInternal(AsyncOperation<? extends U> other, ResultBiFunction<? super T, ? super U, ? extends V> action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        final ResultBiFunction<? super T, ? super U, ? extends V> runnableAction = action;
        return super._thenApplyAsyncInternal(new ResultFunction<Pair<T, U>, V>(){

            @Override
            public V apply(Pair<T, U> value) throws Throwable {
                return runnableAction.apply(value.first, value.second);
            }
        }, executor);
    }

    public <U, V> AsyncOperation<V> thenCombineAsync(@NonNull AsyncOperation<? extends U> other, @NonNull ResultBiFunction<? super T, ? super U, ? extends V> action, @NonNull Executor executor) {
        return this._thenCombineAsyncInternal(other, action, executor);
    }

    public <U, V> AsyncOperation<V> thenCombineAsync(@NonNull AsyncOperation<? extends U> other, @NonNull ResultBiFunction<? super T, ? super U, ? extends V> action) {
        return this._thenCombineAsyncInternal(other, action, sDefaultExecutor);
    }

    public <U, V> AsyncOperation<V> thenCombine(@NonNull AsyncOperation<? extends U> other, @NonNull ResultBiFunction<? super T, ? super U, ? extends V> action) {
        return this._thenCombineAsyncInternal(other, action, sDirectExecutor);
    }

    private <U> AsyncOperation<Void> _thenAcceptBothAsyncInternal(AsyncOperation<? extends U> other, ResultBiConsumer<? super T, ? super U> action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        final ResultBiConsumer<? super T, ? super U> runnableAction = action;
        return super._thenAcceptAsyncInternal(new ResultConsumer<Pair<T, U>>(){

            @Override
            public void accept(Pair<T, U> value) throws Throwable {
                runnableAction.accept(value.first, value.second);
            }
        }, executor);
    }

    public <U> AsyncOperation<Void> thenAcceptBothAsync(@NonNull AsyncOperation<? extends U> other, @NonNull ResultBiConsumer<? super T, ? super U> action, @NonNull Executor executor) {
        return this._thenAcceptBothAsyncInternal(other, action, executor);
    }

    public <U> AsyncOperation<Void> thenAcceptBothAsync(@NonNull AsyncOperation<? extends U> other, @NonNull ResultBiConsumer<? super T, ? super U> action) {
        return this._thenAcceptBothAsyncInternal(other, action, sDefaultExecutor);
    }

    public <U> AsyncOperation<Void> thenAcceptBoth(@NonNull AsyncOperation<? extends U> other, @NonNull ResultBiConsumer<? super T, ? super U> action) {
        return this._thenAcceptBothAsyncInternal(other, action, sDirectExecutor);
    }

    private AsyncOperation<Void> _runAfterBothAsyncInternal(AsyncOperation<?> other, Runnable action, Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        return super._thenRunAsyncInternal(action, executor);
    }

    public AsyncOperation<Void> runAfterBothAsync(@NonNull AsyncOperation<?> other, @NonNull Runnable action, @NonNull Executor executor) {
        return this._runAfterBothAsyncInternal(other, action, executor);
    }

    public AsyncOperation<Void> runAfterBothAsync(@NonNull AsyncOperation<?> other, @NonNull Runnable action) {
        return this._runAfterBothAsyncInternal(other, action, sDefaultExecutor);
    }

    public AsyncOperation<Void> runAfterBoth(@NonNull AsyncOperation<?> other, @NonNull Runnable action) {
        return this._runAfterBothAsyncInternal(other, action, sDirectExecutor);
    }

    private <U> AsyncOperation<U> _thenComposeAsyncInternal(ResultFunction<? super T, ? extends AsyncOperation<U>> action, final Executor executor) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        final AsyncOperation<T> unwrappedOperation = new AsyncOperation<T>();
        final ResultFunction<? super T, ? extends AsyncOperation<U>> runnableAction = action;
        this._whenCompleteAsyncInternal(new ResultBiConsumer<T, Throwable>(){

            @Override
            public void accept(T antecedentValue, Throwable antecedentException) throws Throwable {
                if (antecedentException != null) {
                    unwrappedOperation.completeExceptionally(antecedentException);
                } else {
                    try {
                        AsyncOperation innerOperation = (AsyncOperation)runnableAction.apply(antecedentValue);
                        innerOperation._whenCompleteAsyncInternal(new ResultBiConsumer<U, Throwable>(){

                            @Override
                            public void accept(U antecedentValue, Throwable antecedentException) {
                                if (antecedentException != null) {
                                    unwrappedOperation.completeExceptionally(antecedentException);
                                } else {
                                    unwrappedOperation.complete(antecedentValue);
                                }
                            }
                        }, executor);
                    }
                    catch (Throwable ex) {
                        unwrappedOperation.completeExceptionally(ex);
                    }
                }
            }
        }, executor);
        return unwrappedOperation;
    }

    public <U> AsyncOperation<U> thenComposeAsync(ResultFunction<? super T, ? extends AsyncOperation<U>> action, Executor executor) {
        return this._thenComposeAsyncInternal(action, executor);
    }

    public <U> AsyncOperation<U> thenComposeAsync(@NonNull ResultFunction<? super T, ? extends AsyncOperation<U>> action) {
        return this._thenComposeAsyncInternal(action, sDefaultExecutor);
    }

    public <U> AsyncOperation<U> thenCompose(@NonNull ResultFunction<? super T, ? extends AsyncOperation<U>> action) {
        return this._thenComposeAsyncInternal(action, sDirectExecutor);
    }

    public static <U> AsyncOperation<U> completedFuture(U value) {
        AsyncOperation<U> toReturn = new AsyncOperation<U>();
        toReturn.complete(value);
        return toReturn;
    }

    public static AsyncOperation<Void> runAsync(@NonNull Runnable runnable) {
        return AsyncOperation.runAsync(runnable, sDefaultExecutor);
    }

    public static AsyncOperation<Void> runAsync(@NonNull Runnable runnable, @NonNull Executor executor) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable cannot be null.");
        }
        AsyncOperation<Object> baseOperation = AsyncOperation.completedFuture(null);
        return baseOperation.thenRunAsync(runnable, executor);
    }

    public static <U> AsyncOperation<U> supplyAsync(@NonNull Supplier<U> supplier, @NonNull Executor executor) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier cannot be null.");
        }
        final Supplier<U> runnableSupplier = supplier;
        AsyncOperation<Object> baseOperation = AsyncOperation.completedFuture(null);
        return baseOperation.thenApplyAsync(new ResultFunction<Void, U>(){

            @Override
            public U apply(Void value) throws Throwable {
                return runnableSupplier.get();
            }
        }, executor);
    }

    public static <U> AsyncOperation<U> supplyAsync(@NonNull Supplier<U> supplier) {
        return AsyncOperation.supplyAsync(supplier, sDefaultExecutor);
    }

    public static AsyncOperation<Void> allOf(AsyncOperation<?> ... operations) {
        AsyncOperation<Object> joinOperation = AsyncOperation.completedFuture(null);
        for (AsyncOperation<Object> asyncOperation : operations) {
            joinOperation = asyncOperation.runAfterBoth(joinOperation, new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return joinOperation;
    }

    public static AsyncOperation<Object> anyOf(AsyncOperation<?> ... operations) {
        final AsyncOperation<Object> joinOperation = new AsyncOperation<Object>();
        for (AsyncOperation<?> operation : operations) {
            operation.whenComplete(new ResultBiConsumer<Object, Throwable>(){

                @Override
                public void accept(Object antecedentValue, Throwable antecedentException) {
                    if (antecedentException != null) {
                        joinOperation.completeExceptionally(antecedentException);
                    } else {
                        joinOperation.complete(antecedentValue);
                    }
                }
            });
        }
        return joinOperation;
    }

    private void _invokeDependentOperations(ArrayList<Pair<Runnable, Executor>> operationsToInvoke) {
        if (operationsToInvoke != null) {
            for (Pair<Runnable, Executor> operationPair : operationsToInvoke) {
                ((Executor)operationPair.second).execute((Runnable)operationPair.first);
            }
        }
    }

    private void _checkExecutionException() throws ExecutionException {
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (this.mIsCancelled) {
            throw new CancellationException("Operation was cancelled.");
        }
    }

    private void _checkCompletionException() {
        if (this.mException != null) {
            throw new CompletionException(this.mException);
        }
        if (this.mIsCancelled) {
            throw new CancellationException("Operation was cancelled.");
        }
    }

    private AsyncOperation<T> _buildEitherClause(AsyncOperation<? extends T> other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null.");
        }
        final AsyncOperation<T> joinOperation = new AsyncOperation<T>();
        super._whenCompleteAsyncInternal(new ResultBiConsumer<T, Throwable>(){

            @Override
            public void accept(T antecedentValue, Throwable antecedentException) {
                if (antecedentException != null) {
                    joinOperation.completeExceptionally(antecedentException);
                } else {
                    joinOperation.complete(antecedentValue);
                }
            }
        }, sDirectExecutor);
        this._whenCompleteAsyncInternal(new ResultBiConsumer<T, Throwable>(){

            @Override
            public void accept(T antecedentValue, Throwable antecedentException) {
                if (antecedentException != null) {
                    joinOperation.completeExceptionally(antecedentException);
                } else {
                    joinOperation.complete(antecedentValue);
                }
            }
        }, sDirectExecutor);
        return joinOperation;
    }

    private <U> AsyncOperation<Pair<T, U>> _buildBothClause(AsyncOperation<? extends U> other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null.");
        }
        final AsyncOperation<Pair<T, U>> joinOperation = new AsyncOperation<Pair<T, U>>();
        final AsyncOperation<? extends U> runnableOther = other;
        this._whenCompleteAsyncInternal(new ResultBiConsumer<T, Throwable>(){

            @Override
            public void accept(T antecedentValue, Throwable antecedentException) {
                if (antecedentException != null) {
                    joinOperation.completeExceptionally(antecedentException);
                } else {
                    final Object runnableValue = antecedentValue;
                    runnableOther._whenCompleteAsyncInternal(new ResultBiConsumer<U, Throwable>(){

                        @Override
                        public void accept(U otherAntecedentValue, Throwable otherAntecedentException) {
                            if (otherAntecedentException != null) {
                                joinOperation.completeExceptionally(otherAntecedentException);
                            } else {
                                joinOperation.complete(new Pair(runnableValue, otherAntecedentValue));
                            }
                        }
                    }, sDirectExecutor);
                }
            }
        }, sDirectExecutor);
        return joinOperation;
    }

    private static class Pair<F, S> {
        F first;
        S second;

        Pair(F f, S s) {
            this.first = f;
            this.second = s;
        }
    }

    public static class CompletionException
    extends RuntimeException {
        protected CompletionException() {
        }

        protected CompletionException(String message) {
            super(message);
        }

        CompletionException(String message, Throwable cause) {
            super(message, cause);
        }

        CompletionException(Throwable cause) {
            super(cause);
        }
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get();
    }

    @FunctionalInterface
    public static interface ResultFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ResultBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ResultConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ResultBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Throwable;
    }
}

