/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.support.annotation.Keep;
import com.microsoft.cll.android.AndroidCll;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.TicketObject;
import com.microsoft.cll.android.Verbosity;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

@Keep
class CLLWrapper {
    private static final String IKEY = "A-Rome";
    private static final String ENDPOINT_URL = "https://vortex.data.microsoft.com/collect/v1";
    private static final EventEnums.Latency LATENCY = EventEnums.Latency.LatencyNormal;
    private static final EventEnums.Persistence PERSISTENCE = EventEnums.Persistence.PersistenceNormal;
    private static final EnumSet<EventEnums.Sensitivity> SENSITIVITY = EnumSet.noneOf(EventEnums.Sensitivity.class);
    private static final Double SAMPLE_RATE = 100.0;
    private Context mContext;
    private AndroidCll mCll;

    public CLLWrapper(Context context) {
        this.mContext = context;
    }

    private void setXuidCallback() {
        this.mCll.setXuidCallback(new ITicketCallback(){

            public String getMsaDeviceTicket(boolean forceRefresh) {
                return "";
            }

            public String getAuthXToken(boolean forceRefresh) {
                return "";
            }

            public TicketObject getXTicketForXuid(String xuid) {
                String ticket = CLLWrapper.this.getXTicketForXuidNative(xuid);
                TicketObject ticketObject = new TicketObject(ticket == null ? "" : "d:" + ticket, false);
                if (ticket == null) {
                    CLLWrapper.stopCllAsync(CLLWrapper.this.mCll);
                }
                return ticketObject;
            }
        });
    }

    private static void stopCllAsync(final AndroidCll cll) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                cll.stop();
            }
        }).start();
    }

    native String getXTicketForXuidNative(String var1);

    public void initialize() {
        this.mCll = new AndroidCll(IKEY, this.mContext);
        this.mCll.setEndpointUrl(ENDPOINT_URL);
        this.mCll.setDebugVerbosity(Verbosity.ERROR);
        this.setXuidCallback();
    }

    public void log(String stableUserId, String eventName, String metricsData) {
        this.logInternal(stableUserId, eventName, metricsData, LATENCY, PERSISTENCE, SENSITIVITY, SAMPLE_RATE);
    }

    public void logHighPriority(String stableUserId, String eventName, String metricsData) {
        this.logInternal(stableUserId, eventName, metricsData, LATENCY, EventEnums.Persistence.PersistenceCritical, SENSITIVITY, SAMPLE_RATE);
    }

    public void setUploadInterval(String seconds) {
        this.mCll.OnCllSettingUpdate(SettingsStore.Settings.QUEUEDRAININTERVAL.name(), seconds);
    }

    public void setUploadEventLimit(String events) {
        this.mCll.OnCllSettingUpdate(SettingsStore.Settings.MAXEVENTSPERPOST.name(), events);
    }

    public void start() {
        this.mCll.start();
    }

    public void stop() {
        this.mCll.stop();
    }

    public void pause() {
        this.mCll.pause();
    }

    public void resume() {
        this.mCll.resume();
    }

    public void send() {
        this.mCll.send();
    }

    private void logInternal(String stableUserId, String eventName, String metricsData, EventEnums.Latency latency, EventEnums.Persistence persistence, EnumSet<EventEnums.Sensitivity> sensitivity, double sampleRate) {
        List<String> ids = null;
        if (!stableUserId.isEmpty()) {
            ids = Collections.singletonList(stableUserId);
        }
        this.mCll.log(eventName, metricsData, latency, persistence, sensitivity, sampleRate, ids);
    }
}

