/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.JsonValue;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.Dictionary;
import java.util.Hashtable;

public final class IntentRecognitionResult
extends SpeechRecognitionResult {
    private Dictionary<String, String> entities;
    private String intentId;

    IntentRecognitionResult(long l) {
        super(l);
        Contracts.throwIfNull(super.getImpl(), "resultHandle");
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getIntentId(super.getImpl(), stringRef));
        this.intentId = stringRef.getValue();
        Contracts.throwIfNull(this.intentId, "IntentId");
        if (this.getReason() == ResultReason.RecognizedIntent) {
            String string = this.getProperties().getProperty("LanguageUnderstandingSLE_JsonResult");
            this.entities = new Hashtable<String, String>();
            if (string != null) {
                JsonValue jsonValue = JsonValue.Parse(string);
                int n = jsonValue.count();
                for (int i = 0; i < n; ++i) {
                    String string2 = jsonValue.getName(i);
                    String string3 = jsonValue.get(i).asString();
                    this.entities.put(string2, string3);
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public Dictionary<String, String> getEntities() {
        return this.entities;
    }

    public String getIntentId() {
        return this.intentId;
    }

    @Override
    public String toString() {
        return "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + " IntentId:<" + this.intentId + "> Recognized text:<" + this.getText() + "> Recognized json:<" + this.getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonResult) + "> LanguageUnderstandingJson <" + this.getProperties().getProperty(PropertyId.LanguageUnderstandingServiceResponse_JsonResult) + ">.";
    }

    private final native long getIntentId(SafeHandle var1, StringRef var2);
}

