//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//

#include "com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI.h"
#include "jni_utils.h"
#include "speechapi_c_json.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI
 * Method:    asJsonCopy
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI_builderAsJsonCopy
  (JNIEnv *env, jclass, jobject builderHandle, jint item){
    jlong builder = GetObjectHandle(env, builderHandle);
    const char *res = ai_core_json_value_as_json_copy((SPXHANDLE) builder, item);
    jstring result = env->NewStringUTF(res);
    ai_core_string_free(res);
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI
 * Method:    createJsonBuilderHandle
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI_createJsonBuilderHandle
  (JNIEnv *env, jclass, jobject builderHandle) {
    SPXHANDLE handle = SPXHANDLE_INVALID;
    int item = ai_core_json_builder_create(&handle, "", 0);
    if (item >= 0) {
        SetObjectHandle(env, builderHandle, (jlong) handle);
    }
    return (jint) item;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI
 * Method:    builderAdd
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI_builderAdd
  (JNIEnv *env, jclass, jobject builderHandle, jint jitem, jint index, jstring jfind) {
    jlong builder = GetObjectHandle(env, builderHandle);
    const char *find = GetStringUTFChars(env, jfind);
    int item = ai_core_json_builder_item_add((SPXHANDLE)builder, jitem, index, find);
    ReleaseStringUTFChars(env, jfind, find);
    return (jint)item;
  }

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI
 * Method:    builderSet
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ILjava/lang/String;ILjava/lang/String;ZID)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonBuilderJNI_builderSet
  (JNIEnv *env, jclass, jobject builderHandle, jint jitem, jstring jjsonString, jint type, jstring jstr, jboolean boolValue, jint intValue, jdouble doubleValue) {
    jlong builder = GetObjectHandle(env, builderHandle);
    const char *jsonString = GetStringUTFChars(env, jjsonString);
    jsize jsonSize = 0;
    if(jsonString != nullptr)
    {
      jsonSize = env->GetStringUTFLength(jjsonString);
    }
    const char *str = GetStringUTFChars(env, jstr);
    jsize strSize = 0;
    if(str != nullptr)
    {
      strSize = env->GetStringUTFLength(jstr);
    }
    AZACHR hr = ai_core_json_builder_item_set(
      (SPXHANDLE)builder, jitem, jsonString, jsonSize, type, str, strSize, boolValue, intValue, doubleValue);
    ReleaseStringUTFChars(env, jjsonString, jsonString);
    ReleaseStringUTFChars(env, jstr, str);
    return (jint)hr;
  }
