//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_translation_TranslationRecognitionResult.h"
#include "jni_utils.h"
#include "speechapi_c_translation_result.h"
#include <memory>

/*
 * Class:     com_microsoft_cognitiveservices_speech_translation_TranslationRecognitionResult
 * Method:    getTranslations
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/util/Map;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_translation_TranslationRecognitionResult_getTranslations
  (JNIEnv* env, jobject , jobject translationResultHandle, jobject translationsStringMapRef)
{
    jlong resultHandle = GetObjectHandle(env, translationResultHandle);
    SPX_INIT_HR(hr);

    size_t count = 0;
    hr = translation_text_result_get_translation_count((SPXRESULTHANDLE) resultHandle, &count);
    SPX_THROW_ON_FAIL(hr);

    size_t maxLanguageSize = 0;
    size_t maxTextSize = 0;
    for (size_t i = 0; i < count && SPX_SUCCEEDED(hr); i++)
    {
        size_t languageSize = 0;
        size_t textSize = 0;

        hr = translation_text_result_get_translation((SPXRESULTHANDLE) resultHandle, i, nullptr, nullptr, &languageSize, &textSize);

        maxLanguageSize = std::max(maxLanguageSize, languageSize);
        maxTextSize = std::max(maxTextSize, textSize);
    }

    if (SPX_SUCCEEDED(hr))
    {
        auto targetLanguage = std::make_unique<char[]>(maxLanguageSize);
        auto translationText = std::make_unique<char[]>(maxTextSize);

        for (size_t i = 0; i < count && SPX_SUCCEEDED(hr); i++)
        {
            hr = translation_text_result_get_translation((SPXRESULTHANDLE) resultHandle, i, targetLanguage.get(), translationText.get(), &maxLanguageSize, &maxTextSize);
            if (SPX_SUCCEEDED(hr))
            {
                hr = SetStringMapObjectHandle(env, translationsStringMapRef, targetLanguage.get(), translationText.get());
            }
        }
    }
    return (jlong)hr;
}
