//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber.h"
#include "jni_utils.h"
#include "speechapi_c_factory.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber
 * Method:    createMeetingTranscriberFromConfig
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber_createMeetingTranscriberFromConfig
  (JNIEnv* env, jobject , jobject recognizerHandle, jobject audioConfigHandle)
{
    SPXRECOHANDLE recoHandle = SPXHANDLE_INVALID;
    jlong audioConfig = GetObjectHandle(env, audioConfigHandle);
    SPXHR hr = recognizer_create_meeting_transcriber_from_config(&recoHandle, (SPXAUDIOCONFIGHANDLE)audioConfig);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, recognizerHandle, (jlong)recoHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber
 * Method:    joinMeeting
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber_joinMeeting
  (JNIEnv *env, jobject , jobject recognizerHandle, jobject meetingHandle)
{
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    jlong meetHandle = GetObjectHandle(env, meetingHandle);
    SPXHR hr = recognizer_join_meeting((SPXMEETINGHANDLE)meetHandle, (SPXRECOHANDLE)recoHandle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber
 * Method:    leaveMeeting
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_transcription_MeetingTranscriber_leaveMeeting
  (JNIEnv *env, jobject , jobject recognizerHandle)
{
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    SPXHR hr = recognizer_leave_meeting((SPXRECOHANDLE)recoHandle);
    return (jlong)hr;
}
