//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//

#include <string>
#include <memory>
#include "com_microsoft_cognitiveservices_speech_speaker_VoiceProfile.h"
#include "jni_utils.h"
#include "speechapi_c_speaker_recognition.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfile
 * Method:    createVoiceProfileFromIdAndType
 * Signature: (Ljava/lang/String;ILcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfile_createVoiceProfileFromIdAndType
  (JNIEnv *env, jobject, jstring id, jint type, jobject resultHandle)
{
    SPXVOICEPROFILEHANDLE voiceProfileHandle = SPXHANDLE_INVALID;
    const char* strId = GetStringUTFChars(env, id);
    SPXHR hr = create_voice_profile_from_id_and_type(&voiceProfileHandle, strId, (int)type);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)voiceProfileHandle);
    }
    ReleaseStringUTFChars(env, id, strId);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfile
 * Method:    getId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfile_getId
  (JNIEnv *env, jobject, jobject voiceProfileHandle, jobject resultIdStrRef)
{
    jlong profileHandle = GetObjectHandle(env, voiceProfileHandle);
    // query the string length
    uint32_t length = 0;
    SPXHR hr = voice_profile_get_id((SPXVOICEPROFILEHANDLE)profileHandle, nullptr, &length);
    // retrieve the string
    std::unique_ptr<char[]> buffer(new char[length]);
    if (SPX_SUCCEEDED(hr))
    {
        hr = voice_profile_get_id((SPXVOICEPROFILEHANDLE)profileHandle, buffer.get(), &length);
    }
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, resultIdStrRef, buffer.get());
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfile
 * Method:    getType
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfile_getType
  (JNIEnv *env, jobject, jobject voiceProfileHandle, jobject resultHandle)
{
    int type = 0;
    jlong profileHandle = GetObjectHandle(env, voiceProfileHandle);
    SPXHR hr = voice_profile_get_type((SPXRESULTHANDLE)profileHandle, &type);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)type);
    }
    return (jlong)hr;
}
