//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include <string.h>
#include "com_microsoft_cognitiveservices_speech_speaker_SpeakerVerificationModel.h"
#include "jni_utils.h"
#include "speechapi_c_speaker_recognition.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerVerificationModel
 * Method:    createSpeakerVerificationModel
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerVerificationModel_createSpeakerVerificationModel
  (JNIEnv *env, jclass, jobject modelHandle, jobject profileHandle)
{
    SPXSVMODELHANDLE verificationModelHandle = SPXHANDLE_INVALID;
    jlong voiceProfileHandle = GetObjectHandle(env, profileHandle);
    SPXHR hr = speaker_verification_model_create(&verificationModelHandle, (SPXVOICEPROFILEHANDLE)voiceProfileHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, modelHandle, (jlong)verificationModelHandle);
    }
    return (jlong)hr;
}
