//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//

#include "com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs.h"
#include "jni_utils.h"
#include "speechapi_c_dialog_service_connector.h"
#include <memory>

/*
 * Class:     com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs
 * Method:    getInteractionId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs_getInteractionId
  (JNIEnv *env, jobject, jobject TurnStatusReceivedEventHandle, jobject interactionIdStr)
{
    jlong event = GetObjectHandle(env, TurnStatusReceivedEventHandle);
    size_t size = 0;
    SPXHR hr = dialog_service_connector_turn_status_received_get_interaction_id_size((SPXEVENTHANDLE)event, &size);
    auto interactionId = std::make_unique<char[]>(size + 1);
    if (SPX_SUCCEEDED(hr))
    {
        hr = dialog_service_connector_turn_status_received_get_interaction_id((SPXEVENTHANDLE)event, interactionId.get(), size + 1);
    }
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, interactionIdStr, interactionId.get());
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs
 * Method:    getConversationId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs_getConversationId
  (JNIEnv *env, jobject, jobject TurnStatusReceivedEventHandle, jobject conversationIdStr)
{
    jlong event = GetObjectHandle(env, TurnStatusReceivedEventHandle);
    size_t size = 0;
    SPXHR hr = dialog_service_connector_turn_status_received_get_conversation_id_size((SPXEVENTHANDLE)event, &size);
    auto conversationId = std::make_unique<char[]>(size + 1);
    if (SPX_SUCCEEDED(hr))
    {
        hr = dialog_service_connector_turn_status_received_get_conversation_id((SPXEVENTHANDLE)event, conversationId.get(), size + 1);
    }
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, conversationIdStr, conversationId.get());
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs
 * Method:    getStatusCode
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_dialog_TurnStatusReceivedEventArgs_getStatusCode
  (JNIEnv *env, jobject, jobject TurnStatusReceivedEventHandle, jobject statusCodeNum)
{
    jlong event = GetObjectHandle(env, TurnStatusReceivedEventHandle);
    int statusCode = 404;
    SPXHR hr = dialog_service_connector_turn_status_received_get_status((SPXEVENTHANDLE)event, &statusCode);
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetObjectHandle(env, statusCodeNum, statusCode);
    }
    return (jlong)hr;
}

