//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_audio_AudioConfig.h"
#include "jni_utils.h"
#include "speechapi_c_audio_config.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioInputFromWavFileName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Ljava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioInputFromWavFileName
  (JNIEnv *env, jclass, jobject audioConfigHandle, jstring fileName, jobject audioProcessingOptionsHandle)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    const char *filename = GetStringUTFChars(env, fileName);
    SPXHR hr = audio_config_create_audio_input_from_wav_file_name(&configHandle, filename);
    if (SPX_SUCCEEDED(hr))
    {
        jlong audioProcessingOptions = GetObjectHandle(env, audioProcessingOptionsHandle);
        if (audioProcessingOptions != 0)
        {
            hr = audio_config_set_audio_processing_options(configHandle, (SPXAUDIOPROCESSINGOPTIONSHANDLE)audioProcessingOptions);
        }
    }
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    ReleaseStringUTFChars(env, fileName, filename);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioInputFromDefaultMicrophone
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioInputFromDefaultMicrophone
  (JNIEnv *env, jclass, jobject audioConfigHandle, jobject audioProcessingOptionsHandle)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    SPXHR hr = audio_config_create_audio_input_from_default_microphone(&configHandle);
    if (SPX_SUCCEEDED(hr))
    {
        jlong audioProcessingOptions = GetObjectHandle(env, audioProcessingOptionsHandle);
        if (audioProcessingOptions != 0)
        {
            hr = audio_config_set_audio_processing_options(configHandle, (SPXAUDIOPROCESSINGOPTIONSHANDLE)audioProcessingOptions);
        }
    }
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioInputFromMicrophoneInput
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Ljava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioInputFromMicrophoneInput
  (JNIEnv *env, jclass, jobject audioConfigHandle, jstring micDeviceName, jobject audioProcessingOptionsHandle)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    const char *deviceName = GetStringUTFChars(env, micDeviceName);
    SPXHR hr = audio_config_create_audio_input_from_a_microphone(&configHandle, deviceName);
    if (SPX_SUCCEEDED(hr))
    {
        jlong audioProcessingOptions = GetObjectHandle(env, audioProcessingOptionsHandle);
        if (audioProcessingOptions != 0)
        {
            hr = audio_config_set_audio_processing_options(configHandle, (SPXAUDIOPROCESSINGOPTIONSHANDLE)audioProcessingOptions);
        }
    }
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    ReleaseStringUTFChars(env, micDeviceName, deviceName);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioInputFromStream
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioInputFromStream
  (JNIEnv *env, jclass, jobject audioConfigHandle, jobject audioStreamHandle, jobject audioProcessingOptionsHandle)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    jlong streamHandle = GetObjectHandle(env, audioStreamHandle);
    SPXHR hr = audio_config_create_audio_input_from_stream(&configHandle, (SPXAUDIOSTREAMHANDLE)streamHandle);
    if (SPX_SUCCEEDED(hr))
    {
        jlong audioProcessingOptions = GetObjectHandle(env, audioProcessingOptionsHandle);
        if (audioProcessingOptions != 0)
        {
            hr = audio_config_set_audio_processing_options(configHandle, (SPXAUDIOPROCESSINGOPTIONSHANDLE)audioProcessingOptions);
        }
    }
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioOutputFromDefaultSpeaker
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioOutputFromDefaultSpeaker
  (JNIEnv *env, jclass, jobject audioConfigHandle)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    SPXHR hr = audio_config_create_audio_output_from_default_speaker(&configHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioOutputFromSpeakerOutput
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioOutputFromSpeakerOutput
  (JNIEnv *env, jclass, jobject audioConfigHandle, jstring speakerDeviceName)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    const char *deviceName = GetStringUTFChars(env, speakerDeviceName);
    SPXHR hr = audio_config_create_audio_output_from_a_speaker(&configHandle, deviceName);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    ReleaseStringUTFChars(env, speakerDeviceName, deviceName);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioOutputFromWavFileName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioOutputFromWavFileName
  (JNIEnv *env, jclass, jobject audioConfigHandle, jstring fileName)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    const char* file = GetStringUTFChars(env, fileName);
    SPXHR hr = audio_config_create_audio_output_from_wav_file_name(&configHandle, file);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    ReleaseStringUTFChars(env, fileName, file);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    createAudioOutputFromStream
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_createAudioOutputFromStream
  (JNIEnv *env, jclass, jobject audioConfigHandle, jobject audioOutputStreamHandle)
{
    SPXAUDIOCONFIGHANDLE configHandle = SPXHANDLE_INVALID;
    jlong handle = GetObjectHandle(env, audioOutputStreamHandle);
    SPXHR hr = audio_config_create_audio_output_from_stream(&configHandle, (SPXAUDIOSTREAMHANDLE)handle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioConfigHandle, (jlong)configHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    getAudioProcessingOptions
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_getAudioProcessingOptions
  (JNIEnv *env, jobject, jobject audioConfigHandle, jobject audioProcessingOptionsHandle)
{
    jlong audioConfig = GetObjectHandle(env, audioConfigHandle);
    SPXAUDIOPROCESSINGOPTIONSHANDLE audioProcessingOptions = SPXHANDLE_INVALID;
    SPXHR hr = audio_config_get_audio_processing_options((SPXAUDIOCONFIGHANDLE)audioConfig, &audioProcessingOptions);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioProcessingOptionsHandle, (jlong)audioProcessingOptions);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_audio_AudioConfig
 * Method:    getPropertyBag
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_audio_AudioConfig_getPropertyBag
  (JNIEnv *env, jobject, jobject confHandle, jobject propHandle)
{
    jlong configHandle = GetObjectHandle(env, confHandle);
    SPXPROPERTYBAGHANDLE propertyHandle = SPXHANDLE_INVALID;
    SPXHR hr = audio_config_get_property_bag((SPXSPEECHCONFIGHANDLE)configHandle, &propertyHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, propHandle, (jlong)propertyHandle);
    }
    return (jlong)hr;
}
