//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_ConnectionMessageEventArgs.h"
#include "jni_utils.h"
#include "speechapi_c_connection.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_ConnectionMessageEventArgs
 * Method:    getConnectionMessage
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_ConnectionMessageEventArgs_getConnectionMessage
  (JNIEnv *env, jobject , jobject eventHandle, jobject messageHandle)
{
    SPXCONNECTIONMESSAGEHANDLE connectionMessageHandle = SPXHANDLE_INVALID;
    jlong handle = GetObjectHandle(env, eventHandle);
    SPXHR hr = connection_message_received_event_get_message((SPXEVENTHANDLE) handle, &connectionMessageHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, messageHandle, (jlong)connectionMessageHandle);
    }
    return (jlong)hr;
}
