//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.util;

/*! \cond INTERNAL */
/** 
*  An interface that must be implemented by an item inserted into a KeyedItemHashMap.
*/
public interface KeyedItem {
    /** 
    *  Returns an ID for this item to be used in a KeyedItemHashMap.
    *  @return An ID for this item to be used in a KeyedItemHashMap.
    */
    public String getId();
}
/*! \endcond */