//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.audio;

/**
 * Defines speaker reference channel position in input audio.
 */
public enum SpeakerReferenceChannel {
    /**
     * Indicates that the input audio does not have a speaker reference channel.
     */
    None,

    /**
     * Indicates that the last channel in the input audio corresponds to the speaker
     * reference for echo cancellation.
     */
    LastChannel
}
