//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.audio;

/**
 * Represents the format specified inside WAV container.
 */
public enum AudioStreamWaveFormat {
    /**
     * AudioStreamWaveFormat definition for PCM (pulse-code modulated) data in integer format.
    */
    PCM(0x0001),

    /**
     * AudioStreamWaveFormat definition for A-law-encoded format.
    */
    ALAW(0x0006),

    /**
     * AudioStreamWaveFormat definition for Mu-law-encoded format.
    */
    MULAW(0x0007);

    private AudioStreamWaveFormat(int id) {
        this.id = id;
    }

    /**
     * Returns the internal value Audio Stream Wave Format
     *
     * @return the Audio Stream Wave Format
    */
    public int getValue() { return this.id; }

    private final int id;
}
