/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.util.KeyedItem;
import java.util.ArrayList;
import java.util.Collection;

public class PatternMatchingEntity
implements KeyedItem {
    private String entityId;
    private EntityMatchMode mode;
    private EntityType type;
    public Collection<String> Phrases;

    @Override
    public String getId() {
        return this.entityId;
    }

    public void setId(String string) {
        this.entityId = string;
    }

    public EntityMatchMode getMatchMode() {
        return this.mode;
    }

    public void setMatchMode(EntityMatchMode entityMatchMode) {
        this.mode = entityMatchMode;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType entityType) {
        this.type = entityType;
    }

    protected PatternMatchingEntity(String string, EntityType entityType, EntityMatchMode entityMatchMode, Collection<String> collection) {
        this.entityId = string;
        this.type = entityType;
        this.mode = entityMatchMode;
        this.Phrases = collection == null ? new ArrayList<String>() : collection;
    }

    public static PatternMatchingEntity CreateAnyEntity(String string) {
        return new PatternMatchingEntity(string, EntityType.Any, EntityMatchMode.Basic, null);
    }

    public static PatternMatchingEntity CreateIntegerEntity(String string) {
        return new PatternMatchingEntity(string, EntityType.PrebuiltInteger, EntityMatchMode.Basic, null);
    }

    public static PatternMatchingEntity CreateListEntity(String string, EntityMatchMode entityMatchMode, Collection<String> collection) {
        return new PatternMatchingEntity(string, EntityType.List, entityMatchMode, collection);
    }

    public static PatternMatchingEntity CreateListEntity(String string, EntityMatchMode entityMatchMode, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return new PatternMatchingEntity(string, EntityType.List, entityMatchMode, arrayList);
    }

    public static enum EntityType {
        Any(0),
        List(1),
        PrebuiltInteger(2);

        private final int id;

        private EntityType(int n2) {
            this.id = n2;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum EntityMatchMode {
        Basic(0),
        Strict(1),
        Fuzzy(2);

        private final int id;

        private EntityMatchMode(int n2) {
            this.id = n2;
        }

        public int getValue() {
            return this.id;
        }
    }
}

