/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionResult;
import com.microsoft.cognitiveservices.speech.intent.IntentTrigger;
import com.microsoft.cognitiveservices.speech.intent.LanguageUnderstandingModel;
import com.microsoft.cognitiveservices.speech.intent.PatternMatchingEntity;
import com.microsoft.cognitiveservices.speech.intent.PatternMatchingIntent;
import com.microsoft.cognitiveservices.speech.intent.PatternMatchingModel;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.JsonBuilder;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class IntentRecognizer
extends Recognizer {
    public final EventHandlerImpl<IntentRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<IntentRecognitionEventArgs> recognized;
    public final EventHandlerImpl<IntentRecognitionCanceledEventArgs> canceled;
    static Set<IntentRecognizer> intentRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public IntentRecognizer(SpeechConfig speechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(this.recoHandle, "recoHandle");
        Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), null));
        this.initialize();
    }

    public IntentRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(this.recoHandle, "recoHandle");
        Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, embeddedSpeechConfig.getImpl(), null));
        this.initialize();
    }

    public IntentRecognizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public IntentRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(this.recoHandle, "recoHandle");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, embeddedSpeechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(this.recoHandle, embeddedSpeechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<IntentRecognitionResult> recognizeOnceAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<IntentRecognitionResult>(){

            @Override
            public IntentRecognitionResult call() {
                final IntentRecognitionResult[] intentRecognitionResultArray = new IntentRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognitionResultArray[0] = new IntentRecognitionResult(intentRecognizer.recognize());
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return intentRecognitionResultArray[0];
            }
        });
    }

    public Future<IntentRecognitionResult> recognizeOnceAsync(String string) {
        final IntentRecognizer intentRecognizer = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<IntentRecognitionResult>(){

            @Override
            public IntentRecognitionResult call() {
                final IntentRecognitionResult[] intentRecognitionResultArray = new IntentRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef intRef = new IntRef(0L);
                        Contracts.throwIfNull(intentRecognizer, "Invalid recognizer handle");
                        Contracts.throwIfFail(IntentRecognizer.this.recognizeTextOnce(intentRecognizer.getImpl(), string2, intRef));
                        intentRecognitionResultArray[0] = new IntentRecognitionResult(intRef.getValue());
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return intentRecognitionResultArray[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.startContinuousRecognition(IntentRecognizer.this.recoHandle);
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.stopContinuousRecognition(IntentRecognizer.this.recoHandle);
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public void addIntent(String string) {
        Contracts.throwIfNullOrWhitespace(string, "simplePhrase");
        IntentTrigger intentTrigger = IntentTrigger.fromPhrase(string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string, intentTrigger.getImpl()));
    }

    public void addIntent(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "simplePhrase");
        Contracts.throwIfNullOrWhitespace(string2, "intentId");
        IntentTrigger intentTrigger = IntentTrigger.fromPhrase(string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string2, intentTrigger.getImpl()));
    }

    public void addIntent(LanguageUnderstandingModel languageUnderstandingModel, String string) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        Contracts.throwIfNullOrWhitespace(string, "intentName");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl(), string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string, intentTrigger.getImpl()));
    }

    public void addIntent(LanguageUnderstandingModel languageUnderstandingModel, String string, String string2) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        Contracts.throwIfNullOrWhitespace(string, "intentName");
        Contracts.throwIfNullOrWhitespace(string2, "intentId");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl(), string);
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string2, intentTrigger.getImpl()));
    }

    public void addAllIntents(LanguageUnderstandingModel languageUnderstandingModel, String string) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        Contracts.throwIfNullOrWhitespace(string, "intentId");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl());
        Contracts.throwIfFail(this.addIntent(this.recoHandle, string, intentTrigger.getImpl()));
    }

    public void addAllIntents(LanguageUnderstandingModel languageUnderstandingModel) {
        Contracts.throwIfNull(languageUnderstandingModel, "model");
        IntentTrigger intentTrigger = IntentTrigger.fromModel(languageUnderstandingModel.getImpl());
        Contracts.throwIfFail(this.addIntent(this.recoHandle, null, intentTrigger.getImpl()));
    }

    public Future<Void> startKeywordRecognitionAsync(KeywordRecognitionModel keywordRecognitionModel) {
        Contracts.throwIfNull(keywordRecognitionModel, "model");
        final IntentRecognizer intentRecognizer = this;
        final KeywordRecognitionModel keywordRecognitionModel2 = keywordRecognitionModel;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.startKeywordRecognition(IntentRecognizer.this.recoHandle, keywordRecognitionModel2.getImpl());
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopKeywordRecognitionAsync() {
        final IntentRecognizer intentRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        intentRecognizer.stopKeywordRecognition(IntentRecognizer.this.recoHandle);
                    }
                };
                intentRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public boolean applyLanguageModels(Collection<LanguageUnderstandingModel> collection) throws NullPointerException {
        Contracts.throwIfNull(collection, "collection");
        boolean bl = true;
        Contracts.throwIfFail(this.clearLanguageModels(this.recoHandle));
        for (LanguageUnderstandingModel languageUnderstandingModel : collection) {
            Object object;
            Contracts.throwIfNull(languageUnderstandingModel, "model");
            if (languageUnderstandingModel instanceof PatternMatchingModel) {
                object = (PatternMatchingModel)languageUnderstandingModel;
                String string = this.buildModelJson((PatternMatchingModel)object);
                Contracts.throwIfFail(this.importPatternMatchingModel(this.recoHandle, string.toString()));
                continue;
            }
            if (!(languageUnderstandingModel instanceof LanguageUnderstandingModel)) continue;
            object = IntentTrigger.fromModel(languageUnderstandingModel.getImpl());
            Contracts.throwIfFail(this.addIntent(this.recoHandle, null, ((IntentTrigger)object).getImpl()));
            bl = false;
        }
        return bl;
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.recoHandle != null) {
                this.recoHandle.close();
                this.recoHandle = null;
            }
            intentRecognizerObjects.remove(this);
            super.dispose(bl);
        }
    }

    public SafeHandle getRecoImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        final IntentRecognizer intentRecognizer = this;
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.recognizingSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.recognizedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.canceledSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.sessionStartedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.sessionStoppedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.speechStartDetectedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(intentRecognizer);
                Contracts.throwIfFail(IntentRecognizer.this.speechEndDetectedSetCallback(intentRecognizer.recoHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(intentRecognizer.recoHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionEventArgs intentRecognitionEventArgs = new IntentRecognitionEventArgs(l, true);
            EventHandlerImpl<IntentRecognitionEventArgs> eventHandlerImpl = this.recognizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, intentRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionEventArgs intentRecognitionEventArgs = new IntentRecognitionEventArgs(l, true);
            EventHandlerImpl<IntentRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, intentRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionCanceledEventArgs intentRecognitionCanceledEventArgs = new IntentRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<IntentRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, intentRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildModelJson(PatternMatchingModel patternMatchingModel) {
        int n;
        int n2;
        int n3;
        int n4;
        JsonBuilder jsonBuilder = new JsonBuilder();
        int n5 = jsonBuilder.addItem(jsonBuilder.root, 0, "modelId");
        jsonBuilder.setString(n5, patternMatchingModel.getId());
        int n6 = jsonBuilder.addItem(jsonBuilder.root, 0, "intents");
        jsonBuilder.setJson(n6, "[]");
        int n7 = 0;
        for (PatternMatchingIntent object : patternMatchingModel.getIntents().values()) {
            int patternMatchingEntity = jsonBuilder.addItem(n6, n7, null);
            n4 = jsonBuilder.addItem(patternMatchingEntity, 0, "id");
            jsonBuilder.setString(n4, object.getId());
            n3 = jsonBuilder.addItem(patternMatchingEntity, 0, "phrases");
            n2 = 0;
            jsonBuilder.setJson(n3, "[]");
            for (String n11 : object.Phrases) {
                n = jsonBuilder.addItem(n3, n2, null);
                jsonBuilder.setString(n, n11);
                ++n2;
            }
            ++n7;
        }
        n7 = 0;
        int n9 = jsonBuilder.addItem(jsonBuilder.root, 0, "entities");
        jsonBuilder.setJson(n9, "[]");
        for (PatternMatchingEntity patternMatchingEntity : patternMatchingModel.getEntities().values()) {
            n4 = jsonBuilder.addItem(n9, n7, null);
            n3 = jsonBuilder.addItem(n4, 0, "id");
            jsonBuilder.setString(n3, patternMatchingEntity.getId());
            n2 = jsonBuilder.addItem(n4, 0, "type");
            jsonBuilder.setInteger(n2, patternMatchingEntity.getType().getValue());
            int n8 = jsonBuilder.addItem(n4, 0, "mode");
            jsonBuilder.setInteger(n8, patternMatchingEntity.getMatchMode().getValue());
            int n10 = jsonBuilder.addItem(n4, 0, "phrases");
            n = 0;
            jsonBuilder.setJson(n10, "[]");
            for (String string : patternMatchingEntity.Phrases) {
                int n11 = jsonBuilder.addItem(n10, n, null);
                jsonBuilder.setString(n11, string);
                ++n;
            }
            ++n7;
        }
        return jsonBuilder.toString();
    }

    private final native long addIntent(SafeHandle var1, String var2, SafeHandle var3);

    private final native long clearLanguageModels(SafeHandle var1);

    private final native long createIntentRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long importPatternMatchingModel(SafeHandle var1, String var2);

    private final native long recognizeTextOnce(SafeHandle var1, String var2, IntRef var3);
}

