/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class PullAudioInputStream
extends AudioInputStream {
    private PullAudioInputStreamCallback callbackHandle;

    public static PullAudioInputStream create(PullAudioInputStreamCallback pullAudioInputStreamCallback) {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PullAudioInputStream.createPullAudioInputStream(safeHandle, null));
        return new PullAudioInputStream(safeHandle, pullAudioInputStreamCallback);
    }

    public static PullAudioInputStream create(PullAudioInputStreamCallback pullAudioInputStreamCallback, AudioStreamFormat audioStreamFormat) {
        SafeHandle safeHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PullAudioInputStream.createPullAudioInputStream(safeHandle, audioStreamFormat.getImpl()));
        return new PullAudioInputStream(safeHandle, pullAudioInputStreamCallback);
    }

    @Override
    public void close() {
        this.callbackHandle = null;
        super.close();
    }

    protected PullAudioInputStream(SafeHandle safeHandle, PullAudioInputStreamCallback pullAudioInputStreamCallback) {
        super(safeHandle);
        Contracts.throwIfNull(this.streamHandle, "streamHandle");
        this.callbackHandle = pullAudioInputStreamCallback;
        Contracts.throwIfFail(this.setStreamCallbacks(this.streamHandle));
    }

    private PullAudioInputStreamCallback getCallbackHandle() {
        return this.callbackHandle;
    }

    private static final native long createPullAudioInputStream(SafeHandle var0, SafeHandle var1);

    private final native long setStreamCallbacks(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

