/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class ConnectionMessage
implements AutoCloseable {
    private SafeHandle messageHandle = null;
    private PropertyCollection properties = null;
    private byte[] binaryMessage = null;

    protected ConnectionMessage(long l) {
        Contracts.throwIfNull(l, "message is null");
        this.messageHandle = new SafeHandle(l, SafeHandleType.ConnectionMessage);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.messageHandle, intRef));
        this.properties = new PropertyCollection(intRef);
    }

    public String getPath() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.path");
    }

    public String getTextMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.text.message");
    }

    public byte[] getBinaryMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        if (this.binaryMessage == null) {
            IntRef intRef = new IntRef(0L);
            this.binaryMessage = this.getMessageData(this.messageHandle, intRef);
            Contracts.throwIfFail(intRef.getValue());
        }
        return this.binaryMessage;
    }

    public boolean isBinaryMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.type").equals("binary");
    }

    public boolean isTextMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.type").equals("text");
    }

    public String toString() {
        String string = "";
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        if (this.isTextMessage()) {
            string = "Path: " + this.getPath() + ", Type: text, Message: " + this.getTextMessage();
        } else if (this.isBinaryMessage()) {
            string = "Path: " + this.getPath() + ", Type: binary, Size: " + (this.getBinaryMessage() == null ? 0 : this.getBinaryMessage().length) + " bytes";
        }
        return string;
    }

    public PropertyCollection getProperties() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties;
    }

    @Override
    public void close() {
        if (this.messageHandle != null) {
            this.messageHandle.close();
            this.messageHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
        this.binaryMessage = null;
    }

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native byte[] getMessageData(SafeHandle var1, IntRef var2);
}

