/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration;

import com.microsoft.bot.builder.TypedInvokeResponse;
import com.microsoft.bot.builder.skills.BotFrameworkSkill;
import com.microsoft.bot.builder.skills.SkillConversationIdFactoryBase;
import com.microsoft.bot.builder.skills.SkillConversationIdFactoryOptions;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.integration.BotFrameworkHttpClient;
import com.microsoft.bot.schema.Activity;
import java.net.URI;
import java.util.concurrent.CompletableFuture;

public class SkillHttpClient
extends BotFrameworkHttpClient {
    private final SkillConversationIdFactoryBase conversationIdFactory;

    public SkillHttpClient(CredentialProvider credentialProvider, SkillConversationIdFactoryBase conversationIdFactory, ChannelProvider channelProvider) {
        super(credentialProvider, channelProvider);
        this.conversationIdFactory = conversationIdFactory;
    }

    public <T> CompletableFuture<TypedInvokeResponse<T>> postActivity(String originatingAudience, String fromBotId, BotFrameworkSkill toSkill, URI callbackUrl, Activity activity, Class<T> type) {
        return this.getSkillConversationId(originatingAudience, fromBotId, toSkill, activity).thenCompose(skillConversationId -> this.postActivity(fromBotId, toSkill.getAppId(), toSkill.getSkillEndpoint(), callbackUrl, (String)skillConversationId, activity, type));
    }

    private CompletableFuture<String> getSkillConversationId(String originatingAudience, String fromBotId, BotFrameworkSkill toSkill, Activity activity) {
        try {
            SkillConversationIdFactoryOptions options = new SkillConversationIdFactoryOptions();
            options.setFromBotOAuthScope(originatingAudience);
            options.setFromBotId(fromBotId);
            options.setActivity(activity);
            options.setBotFrameworkSkill(toSkill);
            return this.conversationIdFactory.createSkillConversationId(options);
        }
        catch (Exception ex) {
            return this.conversationIdFactory.createSkillConversationId(activity.getConversationReference());
        }
    }

    public <T> CompletableFuture<TypedInvokeResponse<T>> postActivity(String fromBotId, BotFrameworkSkill toSkill, URI callbackUrl, Activity activity, Class<T> type) {
        String originatingAudience = this.getChannelProvider() != null && this.getChannelProvider().isGovernment() ? "https://api.botframework.us/.default" : "https://api.botframework.com/.default";
        return this.postActivity(originatingAudience, fromBotId, toSkill, callbackUrl, activity, type);
    }
}

