/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration;

import com.microsoft.bot.integration.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class ClasspathPropertiesConfiguration
implements Configuration {
    private Properties properties;

    public ClasspathPropertiesConfiguration() {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("application.properties");){
            this.properties = new Properties();
            this.properties.load(input);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(ClasspathPropertiesConfiguration.class).error("Unable to load properties", (Throwable)e);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String[] getProperties(String key) {
        String baseProperty = this.properties.getProperty(key);
        if (baseProperty != null) {
            String[] splitProperties = baseProperty.split(",");
            return splitProperties;
        }
        return null;
    }
}

