/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.builder.TypedInvokeResponse;
import com.microsoft.bot.builder.skills.BotFrameworkClient;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.AppCredentials;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.connector.authentication.MicrosoftGovernmentAppCredentials;
import com.microsoft.bot.restclient.serializer.JacksonAdapter;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationAccount;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.RoleTypes;
import com.microsoft.bot.schema.Serialization;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class BotFrameworkHttpClient
extends BotFrameworkClient {
    private static Map<String, AppCredentials> appCredentialMapCache = new HashMap<String, AppCredentials>();
    private ChannelProvider channelProvider;
    private CredentialProvider credentialProvider;
    private OkHttpClient httpClient;

    public BotFrameworkHttpClient(CredentialProvider credentialProvider, ChannelProvider channelProvider) {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialProvider cannot be null.");
        }
        this.credentialProvider = credentialProvider;
        this.channelProvider = channelProvider;
        this.httpClient = new OkHttpClient();
    }

    public <T> CompletableFuture<TypedInvokeResponse<T>> postActivity(String fromBotId, String toBotId, URI toUrl, URI serviceUrl, String conversationId, Activity activity, Class<T> type) {
        return this.getAppCredentials(fromBotId, toBotId).thenCompose(appCredentials -> {
            if (appCredentials == null) {
                return Async.completeExceptionally((Throwable)new Exception(String.format("Unable to get appCredentials to connect to the skill", new Object[0])));
            }
            return this.getToken((AppCredentials)appCredentials).thenCompose(token -> {
                Activity activityClone = Activity.clone((Activity)activity);
                ConversationAccount conversationAccount = new ConversationAccount();
                conversationAccount.setId(activityClone.getConversation().getId());
                conversationAccount.setName(activityClone.getConversation().getName());
                conversationAccount.setConversationType(activityClone.getConversation().getConversationType());
                conversationAccount.setAadObjectId(activityClone.getConversation().getAadObjectId());
                conversationAccount.setIsGroup(activityClone.getConversation().isGroup());
                for (String key : conversationAccount.getProperties().keySet()) {
                    activityClone.setProperties(key, (JsonNode)conversationAccount.getProperties().get(key));
                }
                conversationAccount.setRole(activityClone.getConversation().getRole());
                conversationAccount.setTenantId(activityClone.getConversation().getTenantId());
                ConversationReference conversationReference = new ConversationReference();
                conversationReference.setServiceUrl(activityClone.getServiceUrl());
                conversationReference.setActivityId(activityClone.getId());
                conversationReference.setChannelId(activityClone.getChannelId());
                conversationReference.setLocale(activityClone.getLocale());
                conversationReference.setConversation(conversationAccount);
                activityClone.setRelatesTo(conversationReference);
                activityClone.getConversation().setId(conversationId);
                activityClone.setServiceUrl(serviceUrl.toString());
                if (activityClone.getRecipient() == null) {
                    activityClone.setRecipient(new ChannelAccount());
                }
                activityClone.getRecipient().setRole(RoleTypes.SKILL);
                return this.securePostActivity(toUrl, activityClone, (String)token, type);
            });
        });
    }

    private CompletableFuture<String> getToken(AppCredentials appCredentials) {
        if (appCredentials == MicrosoftAppCredentials.empty()) {
            return CompletableFuture.completedFuture(null);
        }
        return appCredentials.getToken();
    }

    public <T> CompletableFuture<TypedInvokeResponse<T>> postActivity(String botId, URI botEndpoint, Activity activity, Class<T> type) {
        return this.getAppCredentials(botId, botId).thenCompose(appCredentials -> {
            if (appCredentials == null) {
                return Async.completeExceptionally((Throwable)new Exception(String.format("Unable to get appCredentials for the bot Id=%s", botId)));
            }
            return this.getToken((AppCredentials)appCredentials).thenCompose(token -> this.securePostActivity(botEndpoint, activity, (String)token, type));
        });
    }

    protected CompletableFuture<AppCredentials> buildCredentials(String appId, String oAuthScope) {
        return this.getCredentialProvider().getAppPassword(appId).thenCompose(appPassword -> {
            MicrosoftAppCredentials appCredentials = this.channelProvider != null && this.getChannelProvider().isGovernment() ? new MicrosoftGovernmentAppCredentials(appId, appPassword, null, oAuthScope) : new MicrosoftAppCredentials(appId, appPassword, null, oAuthScope);
            return CompletableFuture.completedFuture(appCredentials);
        });
    }

    private <T> CompletableFuture<TypedInvokeResponse<T>> securePostActivity(URI toUrl, Activity activity, String token, Class<T> type) {
        String jsonContent = "";
        try {
            ObjectMapper mapper = new JacksonAdapter().serializer();
            jsonContent = mapper.writeValueAsString((Object)activity);
        }
        catch (JsonProcessingException e) {
            return Async.completeExceptionally((Throwable)new RuntimeException("securePostActivity: Unable to serialize the Activity"));
        }
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonContent);
            Request request = this.buildRequest(activity, toUrl, body, token);
            Response response = this.httpClient.newCall(request).execute();
            Object result = Serialization.getAs((Object)response.body().string(), type);
            TypedInvokeResponse returnValue = new TypedInvokeResponse(response.code(), result);
            return CompletableFuture.completedFuture(returnValue);
        }
        catch (IOException e) {
            return Async.completeExceptionally((Throwable)e);
        }
    }

    private Request buildRequest(Activity activity, URI url, RequestBody body, String token) {
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url.toString()).newBuilder();
        Request.Builder requestBuilder = new Request.Builder().url(httpBuilder.build());
        if (token != null) {
            requestBuilder.addHeader("Authorization", String.format("Bearer %s", token));
        }
        requestBuilder.addHeader("x-ms-conversation-id", activity.getConversation().getId());
        requestBuilder.post(body);
        return requestBuilder.build();
    }

    private CompletableFuture<AppCredentials> getAppCredentials(String appId, String oAuthScope) {
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return CompletableFuture.completedFuture(MicrosoftAppCredentials.empty());
        }
        String cacheKey = String.format("%s%s", appId, oAuthScope);
        AppCredentials appCredentials = null;
        appCredentials = appCredentialMapCache.get(cacheKey);
        if (appCredentials != null) {
            return CompletableFuture.completedFuture(appCredentials);
        }
        return this.buildCredentials(appId, String.format("%s/.default", oAuthScope)).thenCompose(credentials -> {
            appCredentialMapCache.put(cacheKey, (AppCredentials)credentials);
            return CompletableFuture.completedFuture(credentials);
        });
    }

    protected static Map<String, AppCredentials> getAppCredentialMapCache() {
        return appCredentialMapCache;
    }

    protected ChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    protected CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }
}

