/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration;

import com.microsoft.bot.builder.ConversationState;
import com.microsoft.bot.builder.MessageFactory;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.integration.Configuration;
import com.microsoft.bot.schema.Activity;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.LoggerFactory;

public class AdapterWithErrorHandler
extends BotFrameworkHttpAdapter {
    private static final String ERROR_MSG_ONE = "The bot encountered an error or bug.";
    private static final String ERROR_MSG_TWO = "To continue to run this bot, please fix the bot source code.";

    public AdapterWithErrorHandler(Configuration withConfiguration) {
        super(withConfiguration);
        this.setOnTurnError((turnContext, exception) -> {
            LoggerFactory.getLogger(AdapterWithErrorHandler.class).error("onTurnError", exception);
            return turnContext.sendActivities(new Activity[]{MessageFactory.text((String)ERROR_MSG_ONE), MessageFactory.text((String)ERROR_MSG_TWO)}).thenCompose(resourceResponse -> this.sendTraceActivity(turnContext, exception));
        });
    }

    public AdapterWithErrorHandler(Configuration withConfiguration, ConversationState withConversationState) {
        super(withConfiguration);
        this.setOnTurnError((turnContext, exception) -> {
            LoggerFactory.getLogger(AdapterWithErrorHandler.class).error("onTurnError", exception);
            return ((CompletableFuture)turnContext.sendActivities(new Activity[]{MessageFactory.text((String)ERROR_MSG_ONE), MessageFactory.text((String)ERROR_MSG_TWO)}).thenCompose(resourceResponse -> this.sendTraceActivity(turnContext, exception))).thenCompose(stageResult -> {
                if (withConversationState != null) {
                    return withConversationState.delete(turnContext).exceptionally(deleteException -> {
                        LoggerFactory.getLogger(AdapterWithErrorHandler.class).error("ConversationState.delete", deleteException);
                        return null;
                    });
                }
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    private CompletableFuture<Void> sendTraceActivity(TurnContext turnContext, Throwable exception) {
        if (StringUtils.equals((CharSequence)turnContext.getActivity().getChannelId(), (CharSequence)"emulator")) {
            Activity traceActivity = new Activity("trace");
            traceActivity.setLabel("TurnError");
            traceActivity.setName("OnTurnError Trace");
            traceActivity.setValue((Object)ExceptionUtils.getStackTrace((Throwable)exception));
            traceActivity.setValueType("https://www.botframework.com/schemas/error");
            return turnContext.sendActivity(traceActivity).thenApply(resourceResponse -> null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

