/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.restclient.serializer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.apigeneration.Beta;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;

@Beta(value=Beta.SinceVersion.V1_7_0)
public class AdditionalPropertiesSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;

    protected AdditionalPropertiesSerializer(Class<?> vc, JsonSerializer<?> defaultSerializer, ObjectMapper mapper) {
        super(vc, false);
        this.defaultSerializer = defaultSerializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                for (Class c : TypeToken.of((Class)beanDesc.getBeanClass()).getTypes().classes().rawTypes()) {
                    Field[] fields;
                    if (c.isAssignableFrom(Object.class)) continue;
                    for (Field field : fields = c.getDeclaredFields()) {
                        JsonProperty property;
                        if (!"additionalProperties".equalsIgnoreCase(field.getName()) || (property = field.getAnnotation(JsonProperty.class)) == null || !property.value().isEmpty()) continue;
                        return new AdditionalPropertiesSerializer(beanDesc.getBeanClass(), serializer, mapper);
                    }
                }
                return serializer;
            }
        });
        return module;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ObjectNode root = (ObjectNode)this.mapper.valueToTree(value);
        Map.Entry additionalPropertiesField = null;
        Iterator fields = root.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if (!"additionalProperties".equalsIgnoreCase((String)field.getKey())) continue;
            additionalPropertiesField = field;
            break;
        }
        if (additionalPropertiesField != null) {
            root.remove((String)additionalPropertiesField.getKey());
            ObjectNode extraProperties = (ObjectNode)additionalPropertiesField.getValue();
            fields = extraProperties.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                root.set((String)field.getKey(), (JsonNode)field.getValue());
            }
        }
        jgen.writeTree((TreeNode)root);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        ((ResolvableSerializer)this.defaultSerializer).resolve(provider);
    }

    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(value, gen, provider);
    }
}

