/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.restclient.credentials;

import com.google.common.io.BaseEncoding;
import com.microsoft.bot.restclient.credentials.BasicAuthenticationCredentials;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class BasicAuthenticationCredentialsInterceptor
implements Interceptor {
    private final BasicAuthenticationCredentials credentials;

    BasicAuthenticationCredentialsInterceptor(BasicAuthenticationCredentials withCredentials) {
        this.credentials = withCredentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String auth = this.credentials.getUserName() + ":" + this.credentials.getPassword();
        auth = BaseEncoding.base64().encode(auth.getBytes(StandardCharsets.UTF_8));
        Request newRequest = chain.request().newBuilder().header("Authorization", "Basic " + auth).build();
        return chain.proceed(newRequest);
    }
}

