/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.ChannelValidation;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.EmulatorValidation;
import com.microsoft.bot.connector.authentication.EnterpriseChannelValidation;
import com.microsoft.bot.connector.authentication.GovernmentChannelValidation;
import com.microsoft.bot.connector.authentication.SkillValidation;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.RoleTypes;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public final class JwtTokenValidation {
    private JwtTokenValidation() {
    }

    public static CompletableFuture<ClaimsIdentity> authenticateRequest(Activity activity, String authHeader, CredentialProvider credentials, ChannelProvider channelProvider) {
        return JwtTokenValidation.authenticateRequest(activity, authHeader, credentials, channelProvider, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> authenticateRequest(Activity activity, String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, AuthenticationConfiguration authConfig) {
        if (authConfig == null) {
            return Async.completeExceptionally(new IllegalArgumentException("authConfig cannot be null"));
        }
        if (StringUtils.isBlank((CharSequence)authHeader)) {
            return credentials.isAuthenticationDisabled().thenApply(isAuthDisable -> {
                if (!isAuthDisable.booleanValue()) {
                    throw new AuthenticationException("No Auth Header. Auth is required.");
                }
                if (activity.getChannelId() != null && activity.getChannelId().equals("emulator") && activity.getRecipient() != null && activity.getRecipient().getRole().equals((Object)RoleTypes.SKILL)) {
                    return SkillValidation.createAnonymousSkillClaim();
                }
                return new ClaimsIdentity("anonymous");
            });
        }
        return JwtTokenValidation.validateAuthHeader(authHeader, credentials, channelProvider, activity.getChannelId(), activity.getServiceUrl(), authConfig);
    }

    public static CompletableFuture<ClaimsIdentity> validateAuthHeader(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String channelId, String serviceUrl) {
        return JwtTokenValidation.validateAuthHeader(authHeader, credentials, channelProvider, channelId, serviceUrl, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> validateAuthHeader(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String channelId, String serviceUrl, AuthenticationConfiguration authConfig) {
        if (StringUtils.isEmpty((CharSequence)authHeader)) {
            return Async.completeExceptionally(new IllegalArgumentException("No authHeader present. Auth is required."));
        }
        return JwtTokenValidation.authenticateToken(authHeader, credentials, channelProvider, channelId, serviceUrl, authConfig).thenApply(identity -> {
            JwtTokenValidation.validateClaims(authConfig, identity.claims());
            return identity;
        });
    }

    private static CompletableFuture<Void> validateClaims(AuthenticationConfiguration authConfig, Map<String, String> claims) {
        if (authConfig.getClaimsValidator() != null) {
            return authConfig.getClaimsValidator().validateClaims(claims);
        }
        if (SkillValidation.isSkillClaim(claims).booleanValue()) {
            return Async.completeExceptionally(new RuntimeException("ClaimValidator is required for validation of Skill Host calls"));
        }
        return CompletableFuture.completedFuture(null);
    }

    private static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String channelId, String serviceUrl, AuthenticationConfiguration authConfig) {
        if (SkillValidation.isSkillToken(authHeader)) {
            return SkillValidation.authenticateChannelToken(authHeader, credentials, channelProvider, channelId, authConfig);
        }
        boolean usingEmulator = EmulatorValidation.isTokenFromEmulator(authHeader);
        if (usingEmulator) {
            return EmulatorValidation.authenticateToken(authHeader, credentials, channelProvider, channelId, authConfig);
        }
        if (channelProvider == null || channelProvider.isPublicAzure()) {
            if (serviceUrl != null) {
                return ChannelValidation.authenticateToken(authHeader, credentials, channelId, serviceUrl, authConfig);
            }
            return ChannelValidation.authenticateToken(authHeader, credentials, channelId, authConfig);
        }
        if (channelProvider.isGovernment()) {
            return GovernmentChannelValidation.authenticateToken(authHeader, credentials, serviceUrl, channelId, authConfig);
        }
        return EnterpriseChannelValidation.authenticateToken(authHeader, credentials, channelProvider, serviceUrl, channelId, authConfig);
    }

    public static String getAppIdFromClaims(Map<String, String> claims) throws IllegalArgumentException {
        if (claims == null) {
            throw new IllegalArgumentException("claims");
        }
        String appId = null;
        String tokenVersion = claims.get("ver");
        appId = StringUtils.isEmpty((CharSequence)tokenVersion) || tokenVersion.equalsIgnoreCase("1.0") ? claims.get("appid") : claims.get("azp");
        return appId;
    }

    public static boolean isValidTokenFormat(String authHeader) {
        if (StringUtils.isEmpty((CharSequence)authHeader)) {
            return false;
        }
        String[] parts = authHeader.split(" ");
        if (parts.length != 2) {
            return false;
        }
        String authScheme = parts[0];
        return StringUtils.equals((CharSequence)authScheme, (CharSequence)"Bearer");
    }
}

