/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import com.microsoft.bot.connector.ExecutorFactory;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.CachingOpenIdMetadata;
import com.microsoft.bot.connector.authentication.CachingOpenIdMetadataResolver;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.EndorsementsValidator;
import com.microsoft.bot.connector.authentication.OpenIdMetadata;
import com.microsoft.bot.connector.authentication.OpenIdMetadataKey;
import com.microsoft.bot.connector.authentication.OpenIdMetadataResolver;
import com.microsoft.bot.connector.authentication.TokenValidationParameters;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingOpenIdMetadata.class);
    private TokenValidationParameters tokenValidationParameters;
    private List<String> allowedSigningAlgorithms;
    private OpenIdMetadataResolver openIdMetadataResolver;
    private OpenIdMetadata openIdMetadata;

    public JwtTokenExtractor(TokenValidationParameters withTokenValidationParameters, String withMetadataUrl, List<String> withAllowedSigningAlgorithms) {
        this.tokenValidationParameters = new TokenValidationParameters(withTokenValidationParameters);
        this.tokenValidationParameters.requireSignedTokens = true;
        this.allowedSigningAlgorithms = withAllowedSigningAlgorithms;
        this.openIdMetadataResolver = this.tokenValidationParameters.issuerSigningKeyResolver == null ? new CachingOpenIdMetadataResolver() : this.tokenValidationParameters.issuerSigningKeyResolver;
        this.openIdMetadata = this.openIdMetadataResolver.get(withMetadataUrl);
    }

    public CompletableFuture<ClaimsIdentity> getIdentity(String authorizationHeader, String channelId) {
        return this.getIdentity(authorizationHeader, channelId, new ArrayList<String>());
    }

    public CompletableFuture<ClaimsIdentity> getIdentity(String authorizationHeader, String channelId, List<String> requiredEndorsements) {
        if (authorizationHeader == null) {
            return CompletableFuture.completedFuture(null);
        }
        String[] parts = authorizationHeader.split(" ");
        if (parts.length == 2) {
            return this.getIdentity(parts[0], parts[1], channelId, requiredEndorsements);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<ClaimsIdentity> getIdentity(String schema, String token, String channelId, List<String> requiredEndorsements) {
        if (!schema.equalsIgnoreCase("bearer") || token == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (!this.hasAllowedIssuer(token)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.validateToken(token, channelId, requiredEndorsements);
    }

    private boolean hasAllowedIssuer(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        return this.tokenValidationParameters.validIssuers != null && this.tokenValidationParameters.validIssuers.contains(decodedJWT.getIssuer());
    }

    private CompletableFuture<ClaimsIdentity> validateToken(String token, String channelId, List<String> requiredEndorsements) {
        return CompletableFuture.supplyAsync(() -> {
            DecodedJWT decodedJWT = JWT.decode((String)token);
            OpenIdMetadataKey key = this.openIdMetadata.getKey(decodedJWT.getKeyId());
            if (key == null) {
                return null;
            }
            Verification verification = JWT.require((Algorithm)Algorithm.RSA256((RSAPublicKey)key.key, null)).acceptLeeway(this.tokenValidationParameters.clockSkew.getSeconds());
            try {
                X509Certificate cert;
                verification.build().verify(token);
                if (this.tokenValidationParameters.validateIssuerSigningKey && key.certificateChain != null && key.certificateChain.size() > 0 && !this.isCertValid(cert = this.decodeCertificate(key.certificateChain.get(0)))) {
                    throw new JWTVerificationException("Signing certificate is not valid");
                }
                if (key.endorsements != null) {
                    boolean isEndorsed = EndorsementsValidator.validate(channelId, key.endorsements);
                    if (!isEndorsed) {
                        throw new AuthenticationException(String.format("Could not validate endorsement for key: %s with endorsements: %s", key.key.toString(), StringUtils.join((Object[])new List[]{key.endorsements})));
                    }
                    boolean additionalEndorsementsSatisfied = requiredEndorsements.stream().allMatch(endorsement -> EndorsementsValidator.validate(endorsement, key.endorsements));
                    if (!additionalEndorsementsSatisfied) {
                        throw new AuthenticationException(String.format("Could not validate additional endorsement for key: %s with endorsements: %s", key.key.toString(), StringUtils.join((Object[])new List[]{requiredEndorsements})));
                    }
                }
                if (!this.allowedSigningAlgorithms.contains(decodedJWT.getAlgorithm())) {
                    throw new AuthenticationException(String.format("Could not validate algorithm for key: %s with algorithms: %s", decodedJWT.getAlgorithm(), StringUtils.join((Object[])new List[]{this.allowedSigningAlgorithms})));
                }
                return new ClaimsIdentity(decodedJWT);
            }
            catch (JWTVerificationException | CertificateException ex) {
                LOGGER.warn(ex.getMessage());
                throw new AuthenticationException(ex);
            }
        }, ExecutorFactory.getExecutor());
    }

    private X509Certificate decodeCertificate(String certStr) throws CertificateException {
        byte[] decoded = Base64.getDecoder().decode(certStr);
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(decoded));
    }

    private boolean isCertValid(X509Certificate cert) {
        if (cert == null) {
            return false;
        }
        long now = new Date().getTime();
        long clockskew = this.tokenValidationParameters.clockSkew.toMillis();
        long startValid = cert.getNotBefore().getTime() - clockskew;
        long endValid = cert.getNotAfter().getTime() + clockskew;
        return now >= startValid && now <= endValid;
    }
}

