/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.AuthenticationConstants;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenExtractor;
import com.microsoft.bot.connector.authentication.TokenValidationParameters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public final class GovernmentChannelValidation {
    private static String openIdMetaDataUrl = "https://login.botframework.azure.us/v1/.well-known/openidconfiguration";

    public static TokenValidationParameters getTokenValidationParameters() {
        TokenValidationParameters tokenValidationParameters = new TokenValidationParameters();
        ArrayList<String> validIssuers = new ArrayList<String>();
        tokenValidationParameters.validIssuers = validIssuers;
        tokenValidationParameters.validateIssuer = true;
        tokenValidationParameters.validateAudience = false;
        tokenValidationParameters.validateLifetime = true;
        tokenValidationParameters.clockSkew = Duration.ofMinutes(5L);
        tokenValidationParameters.requireSignedTokens = true;
        return tokenValidationParameters;
    }

    private GovernmentChannelValidation() {
    }

    public static String getOpenIdMetaDataUrl() {
        return openIdMetaDataUrl;
    }

    public static void setOpenIdMetaDataUrl(String withOpenIdMetaDataUrl) {
        openIdMetaDataUrl = withOpenIdMetaDataUrl;
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, String serviceUrl, String channelId) {
        return GovernmentChannelValidation.authenticateToken(authHeader, credentials, serviceUrl, channelId, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, String serviceUrl, String channelId, AuthenticationConfiguration authConfig) {
        JwtTokenExtractor tokenExtractor = new JwtTokenExtractor(GovernmentChannelValidation.getTokenValidationParameters(), GovernmentChannelValidation.getOpenIdMetaDataUrl(), AuthenticationConstants.ALLOWED_SIGNING_ALGORITHMS);
        return tokenExtractor.getIdentity(authHeader, channelId, authConfig.requiredEndorsements()).thenCompose(identity -> GovernmentChannelValidation.validateIdentity(identity, credentials, serviceUrl));
    }

    public static CompletableFuture<ClaimsIdentity> validateIdentity(ClaimsIdentity identity, CredentialProvider credentials, String serviceUrl) {
        CompletableFuture<ClaimsIdentity> result = new CompletableFuture<ClaimsIdentity>();
        if (identity == null || !identity.isAuthenticated()) {
            result.completeExceptionally(new AuthenticationException("Invalid Identity"));
            return result;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)identity.getIssuer(), (CharSequence)"https://api.botframework.us")) {
            result.completeExceptionally(new AuthenticationException("Wrong Issuer"));
            return result;
        }
        String appIdFromAudienceClaim = identity.claims().get("aud");
        if (StringUtils.isEmpty((CharSequence)appIdFromAudienceClaim)) {
            result.completeExceptionally(new AuthenticationException("No Audience Claim"));
            return result;
        }
        return credentials.isValidAppId(appIdFromAudienceClaim).thenApply(isValid -> {
            if (!isValid.booleanValue()) {
                throw new AuthenticationException(String.format("Invalid AppId passed on token: '%s'.", appIdFromAudienceClaim));
            }
            String serviceUrlClaim = identity.claims().get("serviceurl");
            if (StringUtils.isEmpty((CharSequence)serviceUrl)) {
                throw new AuthenticationException(String.format("Invalid serviceurl passed on token: '%s'.", serviceUrlClaim));
            }
            if (!StringUtils.equals((CharSequence)serviceUrl, (CharSequence)serviceUrlClaim)) {
                throw new AuthenticationException(String.format("serviceurl doesn't match claim: '%s'.", serviceUrlClaim));
            }
            return identity;
        });
    }
}

