/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.AuthenticationConstants;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenExtractor;
import com.microsoft.bot.connector.authentication.TokenValidationParameters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public final class EnterpriseChannelValidation {
    private static TokenValidationParameters getTokenValidationParameters() {
        TokenValidationParameters tokenValidationParamaters = new TokenValidationParameters();
        tokenValidationParamaters.validateIssuer = true;
        ArrayList<String> validIssuers = new ArrayList<String>();
        validIssuers.add("https://api.botframework.com");
        tokenValidationParamaters.validIssuers = validIssuers;
        tokenValidationParamaters.validateAudience = false;
        tokenValidationParamaters.validateLifetime = true;
        tokenValidationParamaters.clockSkew = Duration.ofMinutes(5L);
        tokenValidationParamaters.requireSignedTokens = true;
        return tokenValidationParamaters;
    }

    private EnterpriseChannelValidation() {
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String serviceUrl, String channelId) {
        return EnterpriseChannelValidation.authenticateToken(authHeader, credentials, channelProvider, serviceUrl, channelId, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String serviceUrl, String channelId, AuthenticationConfiguration authConfig) {
        if (authConfig == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Missing AuthenticationConfiguration"));
        }
        return ((CompletableFuture)channelProvider.getChannelService().thenCompose(channelService -> {
            JwtTokenExtractor tokenExtractor = new JwtTokenExtractor(EnterpriseChannelValidation.getTokenValidationParameters(), String.format("https://%s.enterprisechannel.botframework.com/v1/.well-known/openidconfiguration", channelService), AuthenticationConstants.ALLOWED_SIGNING_ALGORITHMS);
            return tokenExtractor.getIdentity(authHeader, channelId, authConfig.requiredEndorsements());
        })).thenCompose(identity -> {
            if (identity == null) {
                throw new AuthenticationException("Invalid Identity");
            }
            return EnterpriseChannelValidation.validateIdentity(identity, credentials, serviceUrl);
        });
    }

    public static CompletableFuture<ClaimsIdentity> validateIdentity(ClaimsIdentity identity, CredentialProvider credentials, String serviceUrl) {
        CompletableFuture<ClaimsIdentity> result = new CompletableFuture<ClaimsIdentity>();
        if (identity == null || !identity.isAuthenticated()) {
            result.completeExceptionally(new AuthenticationException("Invalid Identity"));
            return result;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)identity.getIssuer(), (CharSequence)"https://api.botframework.com")) {
            result.completeExceptionally(new AuthenticationException("Wrong Issuer"));
            return result;
        }
        String appIdFromAudienceClaim = identity.claims().get("aud");
        if (StringUtils.isEmpty((CharSequence)appIdFromAudienceClaim)) {
            result.completeExceptionally(new AuthenticationException("No Audience Claim"));
            return result;
        }
        return credentials.isValidAppId(appIdFromAudienceClaim).thenApply(isValid -> {
            if (!isValid.booleanValue()) {
                throw new AuthenticationException(String.format("Invalid AppId passed on token: '%s'.", appIdFromAudienceClaim));
            }
            String serviceUrlClaim = identity.claims().get("serviceurl");
            if (StringUtils.isEmpty((CharSequence)serviceUrl)) {
                throw new AuthenticationException(String.format("Invalid serviceurl passed on token: '%s'.", serviceUrlClaim));
            }
            if (!StringUtils.equals((CharSequence)serviceUrl, (CharSequence)serviceUrlClaim)) {
                throw new AuthenticationException(String.format("serviceurl doesn't match claim: '%s'.", serviceUrlClaim));
            }
            return identity;
        });
    }
}

